/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.unitTests;

import cytoscape.GraphObjAttributes;
import cytoscape.SelectedSubGraphFactory;
import cytoscape.unitTests.AllTests;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import y.base.Edge;
import y.base.Node;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class SelectedSubGraphFactoryTest
extends TestCase {
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectedSubGraphFactoryTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        Graph2D graph2D = new Graph2D();
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(graph2D, graphObjAttributes, graphObjAttributes2);
        GraphObjAttributes graphObjAttributes3 = selectedSubGraphFactory.getNodeAttributes();
        GraphObjAttributes graphObjAttributes4 = selectedSubGraphFactory.getEdgeAttributes();
        Graph2D graph2D2 = selectedSubGraphFactory.getSubGraph();
        Node[] nodeArray = graph2D2.getNodeArray();
        Edge[] edgeArray = graph2D2.getEdgeArray();
        if (!$assertionsDisabled && nodeArray.length != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && edgeArray.length != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && graphObjAttributes3.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && graphObjAttributes4.size() != 0) {
            throw new AssertionError();
        }
    }

    private void createEdgeAndAttribute(String string, String string2, String string3, GraphObjAttributes graphObjAttributes, HashMap hashMap, Graph2D graph2D) {
        Node node = (Node)hashMap.get(string);
        Node node2 = (Node)hashMap.get(string2);
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && node2 == null) {
            throw new AssertionError();
        }
        Edge edge = graph2D.createEdge(node, node2);
        String string4 = string + " (" + string3 + ") " + string2;
        graphObjAttributes.add("interaction", string4, string3);
        graphObjAttributes.addNameMapping(string4, edge);
    }

    public void testSubGraphOperation() throws Exception {
        Object object;
        int n;
        AllTests.standardOut("testSubGraphOperation");
        String[] stringArray = new String[]{"g0", "g1", "g2", "g3", "g4", "g5", "g6"};
        String[] stringArray2 = new String[]{"argH", "acc", "mmdA", "vng0623g", "gatA", "gatB2", "gltS"};
        if (!$assertionsDisabled && stringArray.length != stringArray2.length) {
            throw new AssertionError();
        }
        Double[] doubleArray = new Double[]{new Double(0.39), new Double(-0.144), null, null, new Double(-0.05), null, null};
        if (!$assertionsDisabled && stringArray.length != doubleArray.length) {
            throw new AssertionError();
        }
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        Node[] nodeArray = new Node[stringArray.length];
        Graph2D graph2D = new Graph2D();
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        for (n = 0; n < stringArray.length; ++n) {
            object = graph2D.createNode(0.0, 0.0, 70.0, 30.0, stringArray[n]);
            hashMap.put(stringArray[n], (Node)object);
            graphObjAttributes.addNameMapping(stringArray[n], object);
            nodeArray[n] = object;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray2[n] == null) continue;
            graphObjAttributes.add("commonName", stringArray[n], stringArray2[n]);
            graphObjAttributes.add("expression", stringArray[n], doubleArray[n]);
        }
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        object = "g5";
        String string = "g4";
        String string2 = "phylogeneticPattern";
        this.createEdgeAndAttribute((String)object, string, string2, graphObjAttributes2, hashMap, graph2D);
        object = "g5";
        string = "g6";
        string2 = "geneFusion";
        this.createEdgeAndAttribute((String)object, string, string2, graphObjAttributes2, hashMap, graph2D);
        object = "g3";
        string = "g1";
        string2 = "geneFusion";
        this.createEdgeAndAttribute((String)object, string, string2, graphObjAttributes2, hashMap, graph2D);
        object = "g3";
        string = "g1";
        string2 = "phylogeneticPattern";
        this.createEdgeAndAttribute((String)object, string, string2, graphObjAttributes2, hashMap, graph2D);
        object = "g4";
        string = "g1";
        string2 = "geneFusion";
        this.createEdgeAndAttribute((String)object, string, string2, graphObjAttributes2, hashMap, graph2D);
        object = "g1";
        string = "g0";
        string2 = "geneFusion";
        this.createEdgeAndAttribute((String)object, string, string2, graphObjAttributes2, hashMap, graph2D);
        String[] stringArray3 = new String[]{stringArray[1], stringArray[3], stringArray[4]};
        String[] stringArray4 = new String[]{stringArray2[1], stringArray2[3], stringArray2[4]};
        Double[] doubleArray2 = new Double[]{doubleArray[1], doubleArray[3], doubleArray[4]};
        for (int i = 0; i < stringArray3.length; ++i) {
            Node node = (Node)hashMap.get(stringArray3[i]);
            NodeRealizer nodeRealizer = graph2D.getRealizer(node);
            nodeRealizer.setSelected(true);
        }
        AllTests.standardOut("--------- edgeAttributes of original" + graphObjAttributes2);
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(graph2D, graphObjAttributes, graphObjAttributes2);
        GraphObjAttributes graphObjAttributes3 = selectedSubGraphFactory.getNodeAttributes();
        GraphObjAttributes graphObjAttributes4 = selectedSubGraphFactory.getEdgeAttributes();
        Graph2D graph2D2 = selectedSubGraphFactory.getSubGraph();
        Node[] nodeArray2 = graph2D2.getNodeArray();
        Edge[] edgeArray = graph2D2.getEdgeArray();
        if (!$assertionsDisabled && nodeArray2.length != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && edgeArray.length != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && graphObjAttributes3.size() != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && graphObjAttributes4.size() != 2) {
            throw new AssertionError();
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            if (!$assertionsDisabled && stringArray4[i] != (String)graphObjAttributes.getValue("commonName", stringArray3[i])) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && doubleArray2[i] != (Double)graphObjAttributes.getValue("expression", stringArray3[i])) {
                throw new AssertionError();
            }
        }
        String[] stringArray5 = new String[]{"g3 (geneFusion) g1", "g3 (phylogeneticPattern) g1", "g4 (geneFusion) g1"};
        String[] stringArray6 = new String[]{"geneFusion", "phylogeneticPattern", "geneFusion"};
        for (int i = 0; i < stringArray5.length; ++i) {
            String string3 = (String)graphObjAttributes2.getValue("interaction", stringArray5[i]);
            if (!$assertionsDisabled && !string3.equals(stringArray6[i])) {
                throw new AssertionError();
            }
        }
    }

    public void testForSurplusEdges() throws Exception {
        AllTests.standardOut("testNoSurplusEdges");
        Graph2D graph2D = new Graph2D();
        Node node = graph2D.createNode(0.0, 0.0, 70.0, 30.0, "A");
        Node node2 = graph2D.createNode(0.0, 0.0, 70.0, 30.0, "B");
        Node node3 = graph2D.createNode(0.0, 0.0, 70.0, 30.0, "C");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.addNameMapping("A", node);
        graphObjAttributes.addNameMapping("B", node2);
        graphObjAttributes.addNameMapping("C", node3);
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        Edge edge = graph2D.createEdge(node, node2);
        String string = "A (test) B";
        graphObjAttributes2.add("interaction", string, "test");
        graphObjAttributes2.addNameMapping(string, edge);
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        nodeRealizer.setSelected(true);
        nodeRealizer = graph2D.getRealizer(node2);
        nodeRealizer.setSelected(true);
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(graph2D, graphObjAttributes, graphObjAttributes2);
        Graph2D graph2D2 = selectedSubGraphFactory.getSubGraph();
        Node[] nodeArray = graph2D2.getNodeArray();
        Edge[] edgeArray = graph2D2.getEdgeArray();
        if (!$assertionsDisabled && nodeArray.length != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && edgeArray.length != 1) {
            throw new AssertionError();
        }
    }

    public void testGraphWithoutLabels() throws Exception {
        AllTests.standardOut("testGraphWithoutLabels");
        Graph2D graph2D = new Graph2D();
        Node node = graph2D.createNode();
        Node node2 = graph2D.createNode();
        Node node3 = graph2D.createNode();
        Node node4 = graph2D.createNode();
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.addNameMapping("A", node);
        graphObjAttributes.addNameMapping("B", node2);
        graphObjAttributes.addNameMapping("C", node3);
        graphObjAttributes.addNameMapping("D", node4);
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        Edge edge = graph2D.createEdge(node, node2);
        String string = "A (test) B";
        graphObjAttributes2.add("interaction", string, "test");
        graphObjAttributes2.addNameMapping(string, edge);
        edge = graph2D.createEdge(node, node3);
        string = "A (test) C";
        graphObjAttributes2.add("interaction", string, "test");
        graphObjAttributes2.addNameMapping(string, edge);
        edge = graph2D.createEdge(node, node4);
        string = "A (test) D";
        graphObjAttributes2.add("interaction", string, "test");
        graphObjAttributes2.addNameMapping(string, edge);
        edge = graph2D.createEdge(node2, node4);
        string = "B (test) D";
        graphObjAttributes2.add("interaction", string, "test");
        graphObjAttributes2.addNameMapping(string, edge);
        edge = graph2D.createEdge(node3, node4);
        string = "C (test) D";
        graphObjAttributes2.add("interaction", string, "test");
        graphObjAttributes2.addNameMapping(string, edge);
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        nodeRealizer.setSelected(true);
        nodeRealizer = graph2D.getRealizer(node2);
        nodeRealizer.setSelected(true);
        nodeRealizer = graph2D.getRealizer(node3);
        nodeRealizer.setSelected(true);
        SelectedSubGraphFactory selectedSubGraphFactory = new SelectedSubGraphFactory(graph2D, graphObjAttributes, graphObjAttributes2);
        Graph2D graph2D2 = selectedSubGraphFactory.getSubGraph();
        Node[] nodeArray = graph2D2.getNodeArray();
        Edge[] edgeArray = graph2D2.getEdgeArray();
        if (!$assertionsDisabled && nodeArray.length != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && edgeArray.length != 2) {
            throw new AssertionError();
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(SelectedSubGraphFactoryTest.class));
    }

    static {
        $assertionsDisabled = !SelectedSubGraphFactoryTest.class.desiredAssertionStatus();
    }
}

