/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.unitTests;

import cytoscape.GraphObjAttributes;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GraphObjAttributesTest
extends TestCase {
    public GraphObjAttributesTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
    }

    public void testSet() throws Exception {
        AllTests.standardOut("testSet");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
    }

    public void testGetSingleStringValueFromVector() throws Exception {
        AllTests.standardOut("testGetSingleStringValueFromVector");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        String string = "synonym 1";
        String string2 = "synonym 2";
        graphObjAttributes.append("synonym", "GAL4", string);
        graphObjAttributes.append("synonym", "GAL4", string2);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        String string3 = graphObjAttributes.getStringValue("synonym", "GAL4");
        GraphObjAttributesTest.assertTrue((boolean)string3.equals(string));
    }

    public void testGetSingleDoubleValueFromVector() throws Exception {
        AllTests.standardOut("testGetSingleDoubleValueFromVector");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        Double d = new Double(1.0);
        Double d2 = new Double(2.0);
        graphObjAttributes.append("score", "GAL4", d);
        graphObjAttributes.append("score", "GAL4", d2);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        Double d3 = graphObjAttributes.getDoubleValue("score", "GAL4");
        GraphObjAttributesTest.assertTrue((boolean)d3.equals(d));
        Object[] objectArray = graphObjAttributes.getArrayValues("score", "GAL4");
        GraphObjAttributesTest.assertTrue((objectArray.length == 2 ? 1 : 0) != 0);
        Double d4 = (Double)objectArray[0];
        Double d5 = (Double)objectArray[1];
        GraphObjAttributesTest.assertTrue((boolean)d4.equals(d));
        GraphObjAttributesTest.assertTrue((boolean)d5.equals(d2));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        graphObjAttributes.add("expressionLevel", "GAL4", 1.8);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        graphObjAttributes.add("expressionLevel", "GAL80", 0.01);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        graphObjAttributes.add("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
        GraphObjAttributes graphObjAttributes2 = (GraphObjAttributes)graphObjAttributes.clone();
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.numberOfAttributes() == 2 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttribute("expressionLevel");
        graphObjAttributes.deleteAttribute("foo");
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.numberOfAttributes() == 2 ? 1 : 0) != 0);
        GraphObjAttributes graphObjAttributes3 = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes3.numberOfAttributes() == 0 ? 1 : 0) != 0);
        graphObjAttributes3.add(graphObjAttributes2);
        GraphObjAttributesTest.assertTrue((graphObjAttributes3.numberOfAttributes() == 2 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes3.getAttributes("GAL4");
        GraphObjAttributesTest.assertTrue((hashMap.size() == 2 ? 1 : 0) != 0);
        graphObjAttributes3.deleteAttribute("expressionLevel");
        graphObjAttributes3.deleteAttribute("foo");
        GraphObjAttributesTest.assertTrue((graphObjAttributes3.numberOfAttributes() == 0 ? 1 : 0) != 0);
        graphObjAttributes3.add("GAL4", hashMap);
        GraphObjAttributesTest.assertTrue((graphObjAttributes3.numberOfAttributes() == 2 ? 1 : 0) != 0);
        graphObjAttributes3.add("whimsical", "GAL4", 101.101);
        HashMap hashMap2 = graphObjAttributes3.getAttributes("GAL4");
        GraphObjAttributesTest.assertTrue((hashMap2.size() == 3 ? 1 : 0) != 0);
        Double d = (Double)hashMap2.get("whimsical");
        GraphObjAttributesTest.assertTrue((boolean)d.equals(new Double(101.101)));
    }

    public void testAddGraphObjAttributes() throws Exception {
        AllTests.standardOut("testAddGraphObjAttributes");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        graphObjAttributes.set("bar", "GAL4", "The Columbia City Ale House");
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("foo"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("bar"));
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("BAR") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("expressionLevel") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("foo") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("bar") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getDoubleValue("expressionLevel", "GAL4").equals(new Double(1.8)));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getDoubleValue("expressionLevel", "GAL80").equals(new Double(0.01)));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getDoubleValue("foo", "GAL4").equals(new Double(321.23)));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getStringValue("bar", "GAL4").equals("The Columbia City Ale House"));
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        graphObjAttributes2.set("homology", string2, d);
        graphObjAttributes2.set("count", string2, n);
        graphObjAttributes2.set("magic", string2, string);
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.getClass("homology") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.getClass("count") == new Integer(0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.getClass("magic") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes2.getDoubleValue("homology", string2).equals(d));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes2.getIntegerValue("count", string2).equals(n));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes2.getStringValue("magic", string2).equals(string));
        graphObjAttributes.add(graphObjAttributes2);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("foo"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("bar"));
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("BAR") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("expressionLevel") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("foo") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("bar") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getDoubleValue("expressionLevel", "GAL4").equals(new Double(1.8)));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getDoubleValue("expressionLevel", "GAL80").equals(new Double(0.01)));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getDoubleValue("foo", "GAL4").equals(new Double(321.23)));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getStringValue("bar", "GAL4").equals("The Columbia City Ale House"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.getClass("homology") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.getClass("count") == new Integer(0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.getClass("magic") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes2.getDoubleValue("homology", string2).equals(d));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes2.getIntegerValue("count", string2).equals(n));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes2.getStringValue("magic", string2).equals(string));
    }

    public void testHasAttribute() throws Exception {
        AllTests.standardOut("testHasAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("foo"));
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("bar") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getObjectCount("expressionLevel") == 2 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getObjectCount("foo") == 1 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getObjectCount("bar") == 0 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("expressionLevel", "GAL4"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("expressionLevel", "GAL80"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("foo", "GAL4"));
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("foo", "GAL4bogus") ? 1 : 0) != 0);
    }

    public void testGetAttributeNames() throws Exception {
        AllTests.standardOut("testGetAttributeNames");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
    }

    public void testGetAttributeByName() throws Exception {
        AllTests.standardOut("testGetAttributeByName");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute("expressionLevel");
        GraphObjAttributesTest.assertTrue((hashMap != null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((hashMap.size() == 2 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("expressionLevel") == Class.forName("java.lang.Double") ? 1 : 0) != 0);
        Object v = hashMap.get("GAL4");
        GraphObjAttributesTest.assertTrue((v.getClass() == Class.forName("java.lang.Double") ? 1 : 0) != 0);
        HashMap hashMap2 = graphObjAttributes.getAttribute("foo");
        GraphObjAttributesTest.assertTrue((hashMap2 != null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((hashMap2.size() == 1 ? 1 : 0) != 0);
        HashMap hashMap3 = graphObjAttributes.getAttribute("bar");
        GraphObjAttributesTest.assertTrue((hashMap3 == null ? 1 : 0) != 0);
    }

    public void testGetOneGeneAttribute() throws Exception {
        AllTests.standardOut("testGetOneGeneAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        double d = 1.8;
        double d2 = 0.01;
        graphObjAttributes.set("expressionLevel", "GAL4", d);
        graphObjAttributes.set("expressionLevel", "GAL80", d2);
        Double d3 = new Double(321.23);
        graphObjAttributes.set("foo", "GAL4", d3);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
        Double d4 = graphObjAttributes.getDoubleValue("expressionLevel", "GAL4");
        GraphObjAttributesTest.assertTrue((d4.compareTo(new Double(d)) == 0 ? 1 : 0) != 0);
        d4 = graphObjAttributes.getDoubleValue("expressionLevel", "GAL80");
        GraphObjAttributesTest.assertTrue((d4.compareTo(new Double(d2)) == 0 ? 1 : 0) != 0);
        d4 = graphObjAttributes.getDoubleValue("foo", "GAL4");
        GraphObjAttributesTest.assertTrue((d4.compareTo(d3) == 0 ? 1 : 0) != 0);
        d4 = graphObjAttributes.getDoubleValue("phoo", "GAL4");
        GraphObjAttributesTest.assertTrue((d4 == null ? 1 : 0) != 0);
        d4 = graphObjAttributes.getDoubleValue("foo", "GUY4");
        GraphObjAttributesTest.assertTrue((d4 == null ? 1 : 0) != 0);
    }

    public void testTextFileReaderOnNodeAttributeData() throws Exception {
        AllTests.standardOut("testTextFileReaderOnNodeAttributeData");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute("fooB");
        GraphObjAttributesTest.assertTrue((hashMap.size() == 333 ? 1 : 0) != 0);
    }

    public void testTextFileReaderOnEdgeAttributeData() throws Exception {
        AllTests.standardOut("testTextFileReaderOnEdgeAttributeData");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        File file = new File("testData/yeastSmall.edgeAttr.0");
        graphObjAttributes.readAttributesFromFile(file);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute(stringArray[0]);
        GraphObjAttributesTest.assertTrue((hashMap.size() == 27 ? 1 : 0) != 0);
    }

    public void testAddAttributeHash() throws Exception {
        AllTests.standardOut("testAddAttributeHash");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute("fooB");
        GraphObjAttributesTest.assertTrue((hashMap.size() == 333 ? 1 : 0) != 0);
        File file = new File("testData/yeastSmall.edgeAttr.0");
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        graphObjAttributes2.readAttributesFromFile(file);
        GraphObjAttributesTest.assertTrue((graphObjAttributes2.numberOfAttributes() == 1 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes2.getAttributeNames();
        HashMap hashMap2 = graphObjAttributes2.getAttribute(stringArray[0]);
        graphObjAttributes.set(graphObjAttributes2);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
        stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        hashMap = graphObjAttributes.getAttribute("fooB");
        GraphObjAttributesTest.assertTrue((hashMap.size() == 333 ? 1 : 0) != 0);
        HashMap hashMap3 = graphObjAttributes.getAttribute("edge_attribute_0");
        GraphObjAttributesTest.assertTrue((hashMap3.size() == 27 ? 1 : 0) != 0);
    }

    public void testNodeToNameMapping() throws Exception {
        AllTests.standardOut("testNodeToNameMapping");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute(string);
        GraphObjAttributesTest.assertTrue((hashMap.size() == 333 ? 1 : 0) != 0);
        Integer n = new Integer(1);
        Integer n2 = new Integer(2);
        String[] stringArray = graphObjAttributes.getObjectNames(string);
        int n3 = stringArray.length / 2;
        int n4 = stringArray.length / 3;
        String string2 = stringArray[stringArray.length / 2];
        String string3 = stringArray[stringArray.length / 3];
        GraphObjAttributesTest.assertTrue((string2 != null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((string3 != null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((string2.length() > 0 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((string3.length() > 0 ? 1 : 0) != 0);
        graphObjAttributes.addNameMapping(string2, n);
        graphObjAttributes.addNameMapping(string3, n2);
        String string4 = graphObjAttributes.getCanonicalName(n);
        GraphObjAttributesTest.assertTrue((boolean)string4.equals(string2));
        String string5 = graphObjAttributes.getCanonicalName(n2);
        GraphObjAttributesTest.assertTrue((boolean)string5.equals(string3));
        String string6 = graphObjAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.assertTrue((string6 == null ? 1 : 0) != 0);
    }

    public void testGetAttributesBundle() throws Exception {
        AllTests.standardOut("testGetAttributesBundle");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        graphObjAttributes.set("homology", string2, d);
        graphObjAttributes.set("count", string2, n);
        graphObjAttributes.set("magic", string2, string);
        HashMap hashMap = graphObjAttributes.getAttributes(string2);
        GraphObjAttributesTest.assertTrue((hashMap.size() == 3 ? 1 : 0) != 0);
        Double d2 = (Double)hashMap.get("homology");
        GraphObjAttributesTest.assertTrue((boolean)d2.equals(d));
        Integer n2 = (Integer)hashMap.get("count");
        GraphObjAttributesTest.assertTrue((boolean)n2.equals(n));
        String string3 = (String)hashMap.get("magic");
        GraphObjAttributesTest.assertTrue((boolean)string3.equals(string));
    }

    public void testAddAttributesBundle() throws Exception {
        AllTests.standardOut("testAddAttributesBundle");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d);
        hashMap.put("count", n);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        HashMap hashMap2 = graphObjAttributes.getAttributes(string2);
        GraphObjAttributesTest.assertTrue((hashMap2.size() == 3 ? 1 : 0) != 0);
        Double d2 = (Double)hashMap2.get("homology");
        GraphObjAttributesTest.assertTrue((boolean)d2.equals(d));
        Integer n2 = (Integer)hashMap2.get("count");
        GraphObjAttributesTest.assertTrue((boolean)n2.equals(n));
        String string3 = (String)hashMap2.get("magic");
        GraphObjAttributesTest.assertTrue((boolean)string3.equals(string));
    }

    public void testCountDuplicateNamesForAttribute() throws Exception {
        AllTests.standardOut("testCountDuplicateNamesForAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.countIdentical("A") == 0 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.countIdentical("B") == 0 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.countIdentical("A") == 1 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.countIdentical("A") == 2 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.countIdentical("B") == 1 ? 1 : 0) != 0);
    }

    public void testGetAndAddNameMapping() throws Exception {
        AllTests.standardOut("testGetAndAddNameMapping");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        HashMap hashMap = graphObjAttributes.getAttribute(string);
        GraphObjAttributesTest.assertTrue((hashMap.size() == 333 ? 1 : 0) != 0);
        Integer n = new Integer(1);
        Integer n2 = new Integer(2);
        String[] stringArray = graphObjAttributes.getObjectNames(string);
        int n3 = stringArray.length / 2;
        int n4 = stringArray.length / 3;
        String string2 = stringArray[n3];
        String string3 = stringArray[n4];
        GraphObjAttributesTest.assertTrue((string2 != null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((string3 != null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((string2.length() > 0 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((string3.length() > 0 ? 1 : 0) != 0);
        graphObjAttributes.addNameMapping(string2, n);
        graphObjAttributes.addNameMapping(string3, n2);
        String string4 = graphObjAttributes.getCanonicalName(n);
        GraphObjAttributesTest.assertTrue((boolean)string4.equals(string2));
        String string5 = graphObjAttributes.getCanonicalName(n2);
        GraphObjAttributesTest.assertTrue((boolean)string5.equals(string3));
        String string6 = graphObjAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.assertTrue((string6 == null ? 1 : 0) != 0);
        HashMap hashMap2 = graphObjAttributes.getNameMap();
        GraphObjAttributesTest.assertTrue((hashMap2.size() == 2 ? 1 : 0) != 0);
        graphObjAttributes.addNameMap(hashMap2);
        GraphObjAttributesTest.assertTrue((hashMap2.size() == 2 ? 1 : 0) != 0);
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        Integer n5 = new Integer(3);
        Integer n6 = new Integer(4);
        int n7 = stringArray.length / 4;
        int n8 = stringArray.length / 5;
        String string7 = stringArray[n7];
        String string8 = stringArray[n8];
        hashMap3.put(n5, string7);
        hashMap3.put(n6, string8);
        graphObjAttributes.addNameMap(hashMap3);
        GraphObjAttributesTest.assertTrue((hashMap2.size() == 4 ? 1 : 0) != 0);
        String string9 = graphObjAttributes.getCanonicalName(n5);
        GraphObjAttributesTest.assertTrue((boolean)string9.equals(string7));
        String string10 = graphObjAttributes.getCanonicalName(n6);
        GraphObjAttributesTest.assertTrue((boolean)string10.equals(string8));
        string6 = graphObjAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.assertTrue((string6 == null ? 1 : 0) != 0);
    }

    public void testGetAttributeClass() throws Exception {
        AllTests.standardOut("testGetAttributeClass");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d);
        hashMap.put("count", n);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        graphObjAttributes.setClass("homology", d.getClass());
        graphObjAttributes.setClass("count", n.getClass());
        graphObjAttributes.setClass("magic", string.getClass());
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("homology") == new Double(0.0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("count") == new Integer(0).getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("magic") == "string".getClass() ? 1 : 0) != 0);
    }

    public void testCloning() throws Exception {
        AllTests.standardOut("testCloning");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d);
        hashMap.put("count", n);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        GraphObjAttributes graphObjAttributes2 = (GraphObjAttributes)graphObjAttributes.clone();
        GraphObjAttributesTest.assertTrue((graphObjAttributes != graphObjAttributes2 ? 1 : 0) != 0);
        String string3 = (String)graphObjAttributes.getValue("magic", "GAL4");
        String string4 = (String)graphObjAttributes2.getValue("magic", "GAL4");
        GraphObjAttributesTest.assertTrue((boolean)string3.equals(string));
        GraphObjAttributesTest.assertTrue((boolean)string4.equals(string));
        String string5 = "shazam!";
        graphObjAttributes2.set("magic", "GAL4", string5);
        String string6 = (String)graphObjAttributes2.get("magic", "GAL4");
        GraphObjAttributesTest.assertTrue((boolean)string6.equals(string5));
        String string7 = (String)graphObjAttributes.get("magic", "GAL4");
        GraphObjAttributesTest.assertTrue((boolean)string7.equals(string));
    }

    public void testDeleteAttribute() throws Exception {
        AllTests.standardOut("testDeleteAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d);
        hashMap.put("count", n);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 3 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttribute("homology");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 2 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("homology") ? 1 : 0) != 0);
        graphObjAttributes.deleteAttribute("count");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("count") ? 1 : 0) != 0);
        graphObjAttributes.deleteAttribute("magic");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 0 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("magic") ? 1 : 0) != 0);
    }

    public void testDeleteAttributeForOneGraphObject() throws Exception {
        AllTests.standardOut("testDeleteAttributeForOneGraphObject");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        Integer n = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d);
        hashMap.put("count", n);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 3 ? 1 : 0) != 0);
        graphObjAttributes.append("homology", "GAL80", new Double(888.88));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("homology", "GAL80"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("homology", "GAL4"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("count", "GAL4"));
        graphObjAttributes.deleteAttribute("homology", "GAL4");
        GraphObjAttributesTest.assertTrue((!graphObjAttributes.hasAttribute("homology", "GAL4") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("homology", "GAL80"));
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.hasAttribute("count", "GAL4"));
    }

    public void testDeleteAttributeValueForOneGraphObject() throws Exception {
        AllTests.standardOut("testDeleteAttributeValueForOneGraphObject");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.append("homolog", "GAL4", "h0");
        graphObjAttributes.append("homolog", "GAL4", "h1");
        graphObjAttributes.append("homolog", "GAL4", "h2");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 1 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getStringArrayValues("homolog", "GAL4");
        GraphObjAttributesTest.assertTrue((stringArray.length == 3 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h0");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h0");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "hohoho");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "hobo");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL5", "hobo");
        graphObjAttributes.deleteAttributeValue("homologue", "GAL4", "hobo");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2 ? 1 : 0) != 0);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h1");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 1 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getStringArrayValues("homolog", "GAL4")[0].equals("h2"));
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h2");
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 0 ? 1 : 0) != 0);
    }

    public void testAttributeCategories() throws Exception {
        AllTests.standardOut("testAttributeCategories");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d = new Double(99.32);
        String string = "amino acid synthesis";
        String string2 = "abracadabra";
        String string3 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d);
        hashMap.put("biological process", string);
        hashMap.put("magic", string2);
        graphObjAttributes.set(string3, hashMap);
        GraphObjAttributesTest.assertTrue((graphObjAttributes.numberOfAttributes() == 3 ? 1 : 0) != 0);
        graphObjAttributes.setCategory("homology", "numerical");
        graphObjAttributes.setCategory("biological process", "annotation");
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("homology").equals("numerical"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getCategory("magic") == null ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("biological process").equals("annotation"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getCategory("nonexistent") == null ? 1 : 0) != 0);
    }

    public void testProcessFileHeader() throws Exception {
        AllTests.standardOut("testProcessFileHeader");
        String string = "SNP Count";
        String string2 = "SNP Count (category=data)";
        String string3 = "SNP Count (class=java.lang.Integer)";
        String string4 = "SNP Count (category=data) (class=java.lang.Integer)";
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.processFileHeader(string);
        graphObjAttributes.processFileHeader(string2);
        graphObjAttributes.processFileHeader(string3);
        graphObjAttributes.processFileHeader(string4);
    }

    public void testClassDeduction() throws Exception {
        AllTests.standardOut("testClassDeduction");
        String string = "32";
        String string2 = "32.23";
        String string3 = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=3294";
        String string4 = "a very fine day in Havanna";
        Class clazz = GraphObjAttributes.deduceClass(string2);
        GraphObjAttributesTest.assertTrue((clazz == Class.forName("java.lang.Double") ? 1 : 0) != 0);
        clazz = GraphObjAttributes.deduceClass(string3);
        GraphObjAttributesTest.assertTrue((clazz == Class.forName("java.net.URL") ? 1 : 0) != 0);
        clazz = GraphObjAttributes.deduceClass(string4);
        GraphObjAttributesTest.assertTrue((clazz == Class.forName("java.lang.String") ? 1 : 0) != 0);
    }

    public void testObjectCreation() throws Exception {
        AllTests.standardOut("testObjectCreation");
        Class<?> clazz = Class.forName("java.lang.Integer");
        Class<?> clazz2 = Class.forName("java.lang.String");
        Class<?> clazz3 = Class.forName("java.lang.Double");
        Class<?> clazz4 = Class.forName("java.net.URL");
        String string = "32";
        String string2 = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=3294";
        Object object = GraphObjAttributes.createInstanceFromString(clazz, string);
        GraphObjAttributesTest.assertTrue((object.getClass() == clazz ? 1 : 0) != 0);
        object = GraphObjAttributes.createInstanceFromString(clazz2, string);
        GraphObjAttributesTest.assertTrue((object.getClass() == clazz2 ? 1 : 0) != 0);
        object = GraphObjAttributes.createInstanceFromString(clazz3, string);
        GraphObjAttributesTest.assertTrue((object.getClass() == clazz3 ? 1 : 0) != 0);
        object = GraphObjAttributes.createInstanceFromString(clazz4, string2);
        GraphObjAttributesTest.assertTrue((object.getClass() == clazz4 ? 1 : 0) != 0);
        try {
            object = GraphObjAttributes.createInstanceFromString(clazz4, string);
            GraphObjAttributesTest.assertTrue((object.getClass() == clazz4 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = GraphObjAttributes.createInstanceFromString(clazz3, string2);
            GraphObjAttributesTest.assertTrue((object.getClass() == clazz2 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAttributeCategoryAndClassDetection() throws Exception {
        AllTests.standardOut("testAttributeCategoryAndClassDetection");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitStringNoCategory.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("sample zero") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("sample zero").equals("unknown"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/explicitStringNoCategory.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("sample zero") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("sample zero").equals("unknown"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitStringWithCategory.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("sample zero") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("sample zero").equals("annotation"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/explicitStringWithCategory.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("sample zero") == "string".getClass() ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("sample zero").equals("annotation"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/explicitUrlWithCategory.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("locusLink") == Class.forName("java.net.URL") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("locusLink").equals("annotation"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitDouble.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("Score") == Class.forName("java.lang.Double") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("Score").equals("unknown"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitUrl.attribute"));
        GraphObjAttributesTest.assertTrue((graphObjAttributes.getClass("Locus Link") == Class.forName("java.net.URL") ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)graphObjAttributes.getCategory("Locus Link").equals("unknown"));
    }

    public void testReadArrayAttributes() throws Exception {
        AllTests.standardOut("testReadArrayAttributes");
        String string = "GO molecular function, level 4";
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitStringArray.attribute"));
        String string2 = "HSD17B2";
        String[] stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)stringArray[0].equals("membrane"));
        GraphObjAttributesTest.assertTrue((boolean)stringArray[1].equals("intracellular"));
        string2 = "CDH3";
        stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)stringArray[0].equals("cell adhesion molecule"));
        string2 = "AP1G1";
        stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.assertTrue((stringArray.length == 3 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)stringArray[0].equals("intracellular"));
        GraphObjAttributesTest.assertTrue((boolean)stringArray[1].equals("clathrin adaptor"));
        GraphObjAttributesTest.assertTrue((boolean)stringArray[2].equals("intracellular transporter"));
        string2 = "E2F4";
        stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        GraphObjAttributesTest.assertTrue((boolean)stringArray[0].equals("DNA binding"));
    }

    public void testGetUniqueValues() throws Exception {
        AllTests.standardOut("testGetUniqueValues");
        String string = "KEGG-2";
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.append("KEGG", "GAL4", "xxx");
        graphObjAttributes.append("KEGG", "GAL4", "yyy");
        graphObjAttributes.append("KEGG", "GAL4", "zzz");
        graphObjAttributes.append("KEGG", "GAL3", "xxx");
        graphObjAttributes.append("KEGG", "GAL3", "yyy");
        graphObjAttributes.append("KEGG", "GAL3", "QQQ");
        Object[] objectArray = graphObjAttributes.getUniqueValues("KEGG");
        GraphObjAttributesTest.assertTrue((objectArray.length == 4 ? 1 : 0) != 0);
        String[] stringArray = graphObjAttributes.getUniqueStringValues("KEGG");
        GraphObjAttributesTest.assertTrue((stringArray.length == 4 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(GraphObjAttributesTest.class));
    }
}

