/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.unitTests;

import cytoscape.CytoscapeConfig;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CytoscapeConfigTest
extends TestCase {
    private static String testDataDirectory = "";

    public CytoscapeConfigTest(String string) {
        super(string);
    }

    public void testAllArgs() throws Exception {
        AllTests.standardOut("testAllArgs");
        String string = "../data/GO";
        String string2 = "../data/galFiltered.gml";
        String string3 = "../data/tideker0/yeastSmall.intr";
        String string4 = "../data/tideker0/gal1-20.mrna";
        String string5 = "xxx.fooB";
        String string6 = "xxx.barA";
        String string7 = "xxx.zooC";
        String string8 = "xxx.edgeA";
        String string9 = "xxx.edgeB";
        String string10 = "Halobacterium sp.";
        String string11 = "hierarchical";
        String[] stringArray = new String[]{"-b", string, "-g", string2, "-i", string3, "-e", string4, "-n", string5, "-n", string6, "-n", string7, "-j", string8, "-j", string9, "-s", string10, "-l", string11, "-h", "-v", "-x"};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getBioDataDirectory().equals(string));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getGeometryFilename().equals(string2));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getInteractionsFilename().equals(string3));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getExpressionFilename().equals(string4));
        CytoscapeConfigTest.assertTrue((!cytoscapeConfig.getWhetherToCopyExpToAttribs() ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfNodeAttributeFiles() == 3 ? 1 : 0) != 0);
        String[] stringArray2 = cytoscapeConfig.getNodeAttributeFilenames();
        CytoscapeConfigTest.assertTrue((stringArray2.length == 3 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray2.length; ++i) {
            String string12 = stringArray2[i];
            CytoscapeConfigTest.assertTrue((string12.equals(string5) || string12.equals(string6) || string12.equals(string7) ? 1 : 0) != 0);
        }
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfEdgeAttributeFiles() == 2 ? 1 : 0) != 0);
        String[] stringArray3 = cytoscapeConfig.getEdgeAttributeFilenames();
        CytoscapeConfigTest.assertTrue((stringArray3.length == 2 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray3.length; ++i) {
            String string13 = stringArray3[i];
            CytoscapeConfigTest.assertTrue((string13.equals(string8) || string13.equals(string9) ? 1 : 0) != 0);
        }
        AllTests.standardOut("--------------------- config: \n" + cytoscapeConfig.toString());
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.helpRequested());
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.displayVersion());
        String[] stringArray4 = cytoscapeConfig.getAllDataFileExtensions();
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getAllDataFileNames().length == 8 ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getAllDataFileExtensions().length == 8 ? 1 : 0) != 0);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray4.length; ++i) {
            if (stringArray4[i].equals("fooB")) {
                bl = true;
            }
            if (!stringArray4[i].equals("intr")) continue;
            bl2 = true;
        }
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultSpeciesName().equals(string10));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultLayoutStrategy().equals(string11));
        CytoscapeConfigTest.assertTrue((boolean)bl);
        CytoscapeConfigTest.assertTrue((boolean)bl2);
    }

    public void testReadProjectFile_1() throws Exception {
        AllTests.standardOut("testReadProjectFile_1");
        String string = testDataDirectory + "src/cytoscape/unitTests/test1.cpr";
        String string2 = new File(string).getAbsoluteFile().getParentFile().getPath();
        String[] stringArray = new String[]{"-p", string};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getProjectFilename().equals(string));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getGeometryFilename().equals(string2 + "/galFiltered.gml"));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getInteractionsFilename().equals(string2 + "/galFiltered.sif"));
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfNodeAttributeFiles() == 2 ? 1 : 0) != 0);
        String[] stringArray2 = cytoscapeConfig.getNodeAttributeFilenames();
        CytoscapeConfigTest.assertTrue((stringArray2.length == 2 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            CytoscapeConfigTest.assertTrue((string3.equals(string2 + "/nodeAttributes1.noa") || string3.equals(string2 + "/nodeAttributes2.noa") ? 1 : 0) != 0);
        }
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfEdgeAttributeFiles() == 2 ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultSpeciesName().equals("Saccharomyces cerevisiae"));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultLayoutStrategy().equals("hierarchical"));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getBioDataDirectory().equals("rmi://hazel/yeast"));
    }

    public void testReadProjectFile_2() throws Exception {
        AllTests.standardOut("testReadProjectFile_2");
        String string = testDataDirectory + "src/cytoscape/unitTests/test2.cpr";
        String string2 = new File(string).getAbsoluteFile().getParentFile().getPath();
        String[] stringArray = new String[]{"-p", string};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getProjectFilename().equals(string));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getGeometryFilename().equals(string2 + "/galFiltered.gml"));
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getInteractionsFilename() == null ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfNodeAttributeFiles() == 2 ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfEdgeAttributeFiles() == 2 ? 1 : 0) != 0);
        String[] stringArray2 = cytoscapeConfig.getNodeAttributeFilenames();
        CytoscapeConfigTest.assertTrue((stringArray2.length == 2 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            CytoscapeConfigTest.assertTrue((string3.equals(string2 + "/nodeAttributes1.noa") || string3.equals(string2 + "/nodeAttributes2.noa") ? 1 : 0) != 0);
        }
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getNumberOfEdgeAttributeFiles() == 2 ? 1 : 0) != 0);
        String[] stringArray3 = cytoscapeConfig.getEdgeAttributeFilenames();
        CytoscapeConfigTest.assertTrue((stringArray3.length == 2 ? 1 : 0) != 0);
        for (int i = 0; i < stringArray3.length; ++i) {
            String string4 = stringArray3[i];
            CytoscapeConfigTest.assertTrue((string4.equals(string2 + "/edgeAttributes1.eda") || string4.equals(string2 + "/edgeAttributes2.eda") ? 1 : 0) != 0);
        }
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultSpeciesName().equals("Saccharomyces cerevisiae"));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultLayoutStrategy().equals("hierarchical"));
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getBioDataDirectory().equals(string2 + "/annotationsAndSynonyms"));
    }

    public void testForExpectedNullValues() throws Exception {
        AllTests.standardOut("testForExpectedNullValues");
        String[] stringArray = new String[]{"-h"};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getBioDataDirectory() == null ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getGeometryFilename() == null ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getInteractionsFilename() == null ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getExpressionFilename() == null ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getAllDataFileNames().length == 0 ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((cytoscapeConfig.getDefaultSpeciesName() == null ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.helpRequested());
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getWhetherToCopyExpToAttribs());
        CytoscapeConfigTest.assertTrue((!cytoscapeConfig.inputsError() ? 1 : 0) != 0);
    }

    public void testLegalArgs0() throws Exception {
        AllTests.standardOut("testLegalArgs0");
        String string = "../data/galFiltered.gml";
        String string2 = "../data/tideker0/yeastSmall.intr";
        String[] stringArray = new String[]{"-g", string, "-i", string2};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.inputsError());
    }

    public void testReadProperties() throws Exception {
        AllTests.standardOut("testReadProperties");
        System.setProperty("CYTOSCAPE_HOME", "src/cytoscape/unitTests/");
        String[] stringArray = new String[]{};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        Properties properties = cytoscapeConfig.getProperties();
        CytoscapeConfigTest.assertTrue((properties.size() > 10 ? 1 : 0) != 0);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultLayoutStrategy().equals("hierarchical"));
        CytoscapeConfigTest.assertTrue((boolean)properties.getProperty("edge.color.controller").equals("interaction"));
        CytoscapeConfigTest.assertTrue((boolean)properties.getProperty("edge.color.map.interaction.pd").equals("255,0,0"));
    }

    public void testConfigDirectFromProperties() throws Exception {
        AllTests.standardOut("testConfigDirectFromProperties");
        System.setProperty("CYTOSCAPE_HOME", "src/cytoscape/unitTests/");
        String[] stringArray = new String[]{};
        CytoscapeConfig cytoscapeConfig = new CytoscapeConfig(stringArray);
        CytoscapeConfigTest.assertTrue((boolean)cytoscapeConfig.getDefaultLayoutStrategy().equals("hierarchical"));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            testDataDirectory = stringArray[0];
        }
        System.out.println("testDataDirectory: " + testDataDirectory);
        TestRunner.run((Test)new TestSuite(CytoscapeConfigTest.class));
    }
}

