/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.undo;

import cytoscape.undo.EdgeHiddenUndoItem;
import cytoscape.undo.EdgeShownUndoItem;
import cytoscape.undo.NodeHiddenUndoItem;
import cytoscape.undo.NodeShownUndoItem;
import cytoscape.undo.UndoManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;

public class UndoableGraphHider {
    Graph graph;
    UndoManager undoManager;
    Set hiddenNodes = new HashSet();
    Set hiddenEdges = new HashSet();

    public UndoableGraphHider(Graph graph, UndoManager undoManager) {
        this.graph = graph;
        this.undoManager = undoManager;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set hide(Node node) {
        HashSet<Edge> hashSet = new HashSet<Edge>();
        if (!this.graph.contains(node)) {
            return hashSet;
        }
        this.hiddenNodes.add(node);
        HashSet<Edge> hashSet2 = new HashSet<Edge>();
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            this.hiddenEdges.add(edge);
            hashSet2.add(edge);
            hashSet.add(edge);
            edgeCursor.next();
        }
        this.undoManager.saveState(new NodeHiddenUndoItem(this, node, hashSet2));
        this.undoManager.pause();
        this.graph.hide(node);
        this.undoManager.resume();
        return hashSet;
    }

    protected void undoHide(Node node) {
        if (!this.hiddenNodes.contains(node)) {
            return;
        }
        this.graph.unhide(node);
        this.hiddenNodes.remove(node);
    }

    protected void redoHide(Node node) {
        if (!this.graph.contains(node)) {
            return;
        }
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            this.hiddenEdges.add(edge);
            edgeCursor.next();
        }
        this.graph.hide(node);
        this.hiddenNodes.add(node);
    }

    public void unhide(Node node) {
        if (!this.hiddenNodes.contains(node)) {
            return;
        }
        this.undoManager.saveState(new NodeShownUndoItem(this, node));
        this.undoManager.pause();
        this.graph.unhide(node);
        this.hiddenNodes.remove(node);
        this.undoManager.resume();
    }

    protected void undoUnhide(Node node) {
        if (!this.graph.contains(node)) {
            return;
        }
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            this.hiddenEdges.add(edge);
            edgeCursor.next();
        }
        this.graph.hide(node);
        this.hiddenNodes.add(node);
    }

    protected void redoUnhide(Node node) {
        if (!this.hiddenNodes.contains(node)) {
            return;
        }
        this.graph.unhide(node);
        this.hiddenNodes.remove(node);
    }

    public void hide(Edge edge) {
        if (!this.graph.contains(edge)) {
            return;
        }
        this.undoManager.saveState(new EdgeHiddenUndoItem(this, edge));
        this.undoManager.pause();
        this.graph.hide(edge);
        this.hiddenEdges.add(edge);
        this.undoManager.resume();
    }

    protected void undoHide(Edge edge) {
        if (!this.hiddenEdges.contains(edge)) {
            return;
        }
        this.graph.unhide(edge);
        this.hiddenEdges.remove(edge);
    }

    protected void redoHide(Edge edge) {
        if (!this.graph.contains(edge)) {
            return;
        }
        this.graph.hide(edge);
        this.hiddenEdges.add(edge);
    }

    public void unhide(Edge edge) {
        if (!this.hiddenEdges.contains(edge)) {
            return;
        }
        this.undoManager.saveState(new EdgeShownUndoItem(this, edge));
        this.undoManager.pause();
        this.graph.unhide(edge);
        this.hiddenEdges.remove(edge);
        this.undoManager.resume();
    }

    protected void undoUnhide(Edge edge) {
        if (!this.graph.contains(edge)) {
            return;
        }
        this.graph.hide(edge);
        this.hiddenEdges.add(edge);
    }

    protected void redoUnhide(Edge edge) {
        if (!this.hiddenEdges.contains(edge)) {
            return;
        }
        this.graph.unhide(edge);
        this.hiddenEdges.remove(edge);
    }

    public void hideSelfLoops() {
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.source().equals(edge.target())) {
                this.hide(edge);
            }
            edgeCursor.next();
        }
    }

    public Set hide(NodeCursor nodeCursor) {
        this.graph.firePreEvent();
        HashSet hashSet = new HashSet();
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            hashSet.addAll(this.hide(nodeCursor.node()));
            nodeCursor.next();
        }
        this.graph.firePostEvent();
        return hashSet;
    }

    public Set hide(NodeList nodeList) {
        return this.hide(nodeList.nodes());
    }

    public Set hideNodes() {
        return this.hide(this.graph.nodes());
    }

    public void unhideNodes() {
        this.graph.firePreEvent();
        HashSet hashSet = new HashSet(this.hiddenNodes);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.unhide((Node)iterator.next());
        }
        this.graph.firePostEvent();
    }

    public void hide(EdgeCursor edgeCursor) {
        this.graph.firePreEvent();
        edgeCursor.toFirst();
        while (edgeCursor.ok()) {
            this.hide(edgeCursor.edge());
            edgeCursor.next();
        }
        this.graph.firePostEvent();
    }

    public void hide(EdgeList edgeList) {
        this.hide(edgeList.edges());
    }

    public void hideEdges() {
        this.hide(this.graph.edges());
    }

    public void unhideEdges() {
        this.graph.firePreEvent();
        HashSet hashSet = new HashSet(this.hiddenEdges);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.unhide((Edge)iterator.next());
        }
        this.graph.firePostEvent();
    }

    public void unhideAll() {
        this.graph.firePreEvent();
        HashSet hashSet = new HashSet(this.hiddenNodes);
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            this.unhide((Node)object.next());
        }
        object = new HashSet(this.hiddenEdges);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            this.unhide((Edge)iterator.next());
        }
        this.hiddenNodes.clear();
        this.hiddenEdges.clear();
        this.graph.firePostEvent();
    }
}

