/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.undo;

import cytoscape.undo.UndoItem;
import cytoscape.undo.UndoItemList;
import java.util.Vector;

public class UndoManager {
    Vector history = new Vector();
    int historyPosition = 0;
    static final int MAX_HISTORY_SIZE = 20;
    int pauseDepth = 0;
    int squishDepth;
    UndoItemList itemList = null;

    public boolean undo() {
        if (this.historyPosition == 0) {
            return false;
        }
        this.pause();
        UndoItem undoItem = (UndoItem)this.history.get(--this.historyPosition);
        boolean bl = undoItem.undo();
        this.resume();
        return bl;
    }

    public boolean redo() {
        if (this.historyPosition == this.history.size()) {
            return false;
        }
        this.pause();
        UndoItem undoItem = (UndoItem)this.history.get(this.historyPosition++);
        boolean bl = undoItem.redo();
        this.resume();
        return bl;
    }

    public int undoLength() {
        return this.historyPosition;
    }

    public int redoLength() {
        return this.history.size() - this.historyPosition;
    }

    public void saveState(UndoItem undoItem) {
        if (this.pauseDepth > 0) {
            return;
        }
        if (this.itemList != null) {
            this.itemList.add(undoItem);
        } else {
            while (this.historyPosition < this.history.size()) {
                this.history.remove(this.historyPosition);
            }
            this.history.add(undoItem);
            if (this.historyPosition == 20) {
                this.history.remove(0);
            } else {
                ++this.historyPosition;
            }
        }
    }

    public void clearHistory() {
        this.historyPosition = 0;
        this.history.removeAllElements();
    }

    public void pause() {
        ++this.pauseDepth;
    }

    public void resume() {
        --this.pauseDepth;
    }

    public void beginUndoItemList() {
        ++this.squishDepth;
        if (this.itemList == null) {
            this.itemList = new UndoItemList();
        }
    }

    public void endUndoItemList() {
        --this.squishDepth;
        if (this.squishDepth == 0) {
            UndoItemList undoItemList = this.itemList;
            this.itemList = null;
            this.saveState(undoItemList);
        }
    }
}

