/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.undo;

import cytoscape.undo.UndoItem;
import java.util.HashMap;
import y.base.Edge;
import y.base.Node;
import y.base.NodeCursor;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class RealizerUndoItem
implements UndoItem {
    Graph2D graph;
    HashMap nodeRealizers;
    HashMap edgeRealizers;
    NodeRealizer defaultNodeRealizer;
    EdgeRealizer defaultEdgeRealizer;
    RealizerUndoItem redo;

    public RealizerUndoItem(Graph2D graph2D) {
        NodeRealizer nodeRealizer;
        this.graph = graph2D;
        this.defaultNodeRealizer = graph2D.getDefaultNodeRealizer().createCopy();
        this.defaultEdgeRealizer = graph2D.getDefaultEdgeRealizer().createCopy();
        this.nodeRealizers = new HashMap();
        this.edgeRealizers = new HashMap();
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            nodeRealizer = graph2D.getRealizer(nodeCursor.node());
            this.nodeRealizers.put(nodeCursor.node(), nodeRealizer.createCopy());
            nodeCursor.next();
        }
        nodeCursor = graph2D.edges();
        while (nodeCursor.ok()) {
            nodeRealizer = graph2D.getRealizer(nodeCursor.edge());
            this.edgeRealizers.put(nodeCursor.edge(), nodeRealizer.createCopy());
            nodeCursor.next();
        }
    }

    public boolean undo() {
        int n;
        this.redo = new RealizerUndoItem(this.graph);
        this.graph.setDefaultNodeRealizer(this.defaultNodeRealizer);
        this.graph.setDefaultEdgeRealizer(this.defaultEdgeRealizer);
        Node[] nodeArray = this.nodeRealizers.keySet().toArray(new Node[0]);
        Edge[] edgeArray = this.edgeRealizers.keySet().toArray(new Edge[0]);
        for (n = 0; n < nodeArray.length; ++n) {
            this.graph.setRealizer(nodeArray[n], (NodeRealizer)this.nodeRealizers.get(nodeArray[n]));
        }
        for (n = 0; n < edgeArray.length; ++n) {
            this.graph.setRealizer(edgeArray[n], (EdgeRealizer)this.edgeRealizers.get(edgeArray[n]));
        }
        return true;
    }

    public boolean redo() {
        return this.redo.undo();
    }
}

