/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.undo;

import cytoscape.CytoscapeWindow;
import cytoscape.undo.EdgeCreationUndoItem;
import cytoscape.undo.EdgeRemovalUndoItem;
import cytoscape.undo.NodeCreationUndoItem;
import cytoscape.undo.NodeRemovalUndoItem;
import cytoscape.undo.RealizerUndoItem;
import cytoscape.undo.UndoManager;
import y.base.Edge;
import y.base.Graph;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.view.Graph2D;

public class CytoscapeUndoManager
extends UndoManager
implements GraphListener {
    CytoscapeWindow window;
    Graph2D graph;
    int ignoreEventDepth;
    int preEventDepth;

    public CytoscapeUndoManager(CytoscapeWindow cytoscapeWindow, Graph2D graph2D) {
        this.window = cytoscapeWindow;
        this.graph = graph2D;
        this.ignoreEventDepth = 0;
        this.preEventDepth = 0;
    }

    public void onGraphEvent(GraphEvent graphEvent) {
        if (this.ignoreEventDepth > 0) {
            if (graphEvent.getType() == 12) {
                ++this.ignoreEventDepth;
            } else if (graphEvent.getType() == 13) {
                --this.ignoreEventDepth;
            }
        } else {
            Object var2_2 = null;
            switch (graphEvent.getType()) {
                case 12: {
                    ++this.preEventDepth;
                    this.beginUndoItemList();
                    this.saveState(new RealizerUndoItem(this.graph));
                    break;
                }
                case 13: {
                    --this.preEventDepth;
                    this.endUndoItemList();
                    break;
                }
                case 1: 
                case 7: {
                    this.saveState(new EdgeCreationUndoItem((Graph)this.graph, (Edge)graphEvent.getData()));
                    break;
                }
                case 0: 
                case 6: {
                    this.saveState(new NodeCreationUndoItem((Graph)this.graph, (Node)graphEvent.getData()));
                    break;
                }
                case 4: {
                    this.saveState(new EdgeRemovalUndoItem((Graph)this.graph, (Edge)graphEvent.getData()));
                    break;
                }
                case 2: {
                    this.saveState(new NodeRemovalUndoItem((Graph)this.graph, (Node)graphEvent.getData()));
                    break;
                }
            }
            this.window.updateUndoRedoMenuItemStatus();
        }
    }

    public void saveRealizerState() {
        this.saveState(new RealizerUndoItem(this.graph));
        this.window.updateUndoRedoMenuItemStatus();
    }

    public void pause() {
        ++this.ignoreEventDepth;
        this.graph.firePreEvent();
        super.pause();
    }

    public void resume() {
        this.graph.firePostEvent();
        --this.ignoreEventDepth;
        super.resume();
    }
}

