/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.GraphObjAttributes;
import java.util.Hashtable;
import java.util.Iterator;
import y.base.Edge;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.YList;
import y.util.GraphHider;
import y.view.Graph2D;

public class ReduceEquivalentNodes {
    GraphObjAttributes nodeAttributes;
    GraphObjAttributes edgeAttributes;
    Graph2D graph;
    GraphHider graphHider;
    NodeMap node2key;
    Hashtable key2nodes;

    public ReduceEquivalentNodes(GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, Graph2D graph2D) {
        System.out.println("Reducing network");
        this.nodeAttributes = graphObjAttributes;
        this.edgeAttributes = graphObjAttributes2;
        this.graph = graph2D;
        this.graphHider = new GraphHider((Graph)graph2D);
        this.node2key = graph2D.createNodeMap();
        this.key2nodes = new Hashtable();
        this.computeReduction();
        this.performReduction();
        System.out.println("Reduction Finished");
    }

    void computeReduction() {
        boolean bl = false;
        this.graphHider.unhideAll();
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            String string = this.nodeAttributes.getCanonicalName(node);
            YList yList = new YList();
            Object object = node.edges();
            while (object.ok()) {
                Edge edge = object.edge();
                Node node2 = edge.opposite(node);
                String string2 = this.edgeAttributes.getCanonicalName(edge);
                String string3 = (String)this.edgeAttributes.getValue("interaction", string2);
                if (string3.equals("pd") && edge.target() == node) {
                    string3 = "dp";
                }
                String string4 = this.nodeAttributes.getCanonicalName(node2) + string3;
                yList.add((Object)string4);
                object.next();
            }
            object = this.collapseToString(yList);
            this.node2key.set((Object)node, object);
            YList yList2 = (YList)this.key2nodes.get(object);
            if (yList2 == null) {
                yList2 = new YList();
            }
            yList2.add((Object)node);
            this.key2nodes.put(object, yList2);
            nodeCursor.next();
        }
    }

    void performReduction() {
        int n = 0;
        this.graph.firePreEvent();
        Iterator iterator = this.key2nodes.values().iterator();
        while (iterator.hasNext()) {
            YList yList = (YList)iterator.next();
            if (yList.size() < 2) continue;
            String string = "Group " + n++;
            System.out.print(string + ": ");
            YCursor yCursor = yList.cursor();
            Node node = (Node)yCursor.current();
            System.out.print(" " + this.graph.getLabelText(node));
            this.graph.setLabelText(node, string);
            this.nodeAttributes.addNameMapping(string, node);
            yCursor.next();
            while (yCursor.ok()) {
                node = (Node)yCursor.current();
                System.out.print(" " + this.graph.getLabelText(node));
                this.graph.removeNode(node);
                yCursor.next();
            }
            System.out.println();
        }
        this.graph.firePostEvent();
    }

    String collapseToString(YList yList) {
        String string = new String();
        yList.sort();
        YCursor yCursor = yList.cursor();
        while (yCursor.ok()) {
            string = string + yCursor.current();
            yCursor.next();
        }
        return string;
    }
}

