/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import y.layout.hierarchic.AsIsLayerer;
import y.layout.hierarchic.BFSLayerer;
import y.layout.hierarchic.HierarchicLayouter;
import y.layout.hierarchic.Layerer;
import y.layout.hierarchic.TopologicalLayerer;

public class HierarchicalLayoutDialog
extends JDialog {
    JFormattedTextField nodeDistanceField;
    JFormattedTextField layerDistanceField;
    JFormattedTextField edgeDistanceField;
    JComboBox layererList;
    JComboBox routingList;
    JComboBox layoutList;
    Hashtable layererHash;
    Hashtable routingHash;
    Hashtable layoutHash;
    JCheckBox usePortsBox;
    JCheckBox removeFalseCrossingsBox;
    HierarchicLayouter layouter;

    public HierarchicalLayoutDialog(Frame frame) {
        super(frame, true);
        this.setTitle("Hierarchical Layout Options");
        this.layouter = new HierarchicLayouter();
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 2);
        jPanel.setLayout(gridLayout);
        this.layerDistanceField = this.addDoubleField(jPanel, "Minimum Layer Distance", 100.0);
        this.nodeDistanceField = this.addDoubleField(jPanel, "Minimum Node Distance", 60.0);
        this.edgeDistanceField = this.addDoubleField(jPanel, "Minimum Edge Distance", 40.0);
        JLabel jLabel = new JLabel("Layering Algorithm");
        String[] stringArray = new String[]{"None", "BFS", "Topological"};
        Layerer[] layererArray = new Layerer[]{new AsIsLayerer(), new BFSLayerer(), new TopologicalLayerer()};
        this.layererHash = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            this.layererHash.put(stringArray[i], layererArray[i]);
        }
        this.layererList = new JComboBox<String>(stringArray);
        this.layererList.setSelectedIndex(0);
        jPanel.add(jLabel);
        jPanel.add(this.layererList);
        JLabel jLabel2 = new JLabel("Routing Style");
        String[] stringArray2 = new String[]{"Orthogonal", "Polyline"};
        Byte[] byteArray = new Byte[]{new Byte(1), new Byte(0)};
        this.routingHash = new Hashtable();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.routingHash.put(stringArray2[i], byteArray[i]);
        }
        this.routingList = new JComboBox<String>(stringArray2);
        this.routingList.setSelectedIndex(0);
        jPanel.add(jLabel2);
        jPanel.add(this.routingList);
        JLabel jLabel3 = new JLabel("Layout Style");
        String[] stringArray3 = new String[]{"Linear Segments", "Pendulum", "Polyline"};
        Byte[] byteArray2 = new Byte[]{new Byte(1), new Byte(0), new Byte(2)};
        this.layoutHash = new Hashtable();
        for (int i = 0; i < stringArray3.length; ++i) {
            this.layoutHash.put(stringArray3[i], byteArray2[i]);
        }
        this.layoutList = new JComboBox<String>(stringArray3);
        this.layoutList.setSelectedIndex(0);
        jPanel.add(jLabel3);
        jPanel.add(this.layoutList);
        this.removeFalseCrossingsBox = new JCheckBox("Remove False Crossings");
        jPanel.add(this.removeFalseCrossingsBox);
        JButton jButton = new JButton("Apply");
        jButton.addActionListener(new ApplyAction());
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new CancelAction());
        jPanel.add(jButton2);
        this.setContentPane(jPanel);
    }

    private JFormattedTextField addDoubleField(JPanel jPanel, String string, double d) {
        DecimalFormat decimalFormat = new DecimalFormat("###.#");
        NumberFormatter numberFormatter = new NumberFormatter(decimalFormat);
        numberFormatter.setValueClass(Double.class);
        numberFormatter.setOverwriteMode(true);
        numberFormatter.setAllowsInvalid(false);
        JLabel jLabel = new JLabel(string);
        jPanel.add(jLabel);
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        jFormattedTextField.setValue(new Double(d));
        jFormattedTextField.setPreferredSize(new Dimension(100, 20));
        jPanel.add(jFormattedTextField);
        return jFormattedTextField;
    }

    public HierarchicLayouter getLayouter() {
        return this.layouter;
    }

    public class CancelAction
    extends AbstractAction {
        CancelAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HierarchicalLayoutDialog.this.dispose();
        }
    }

    public class ApplyAction
    extends AbstractAction {
        String item;

        ApplyAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.item = (String)HierarchicalLayoutDialog.this.layererList.getSelectedItem();
            HierarchicalLayoutDialog.this.layouter.setLayerer((Layerer)HierarchicalLayoutDialog.this.layererHash.get(this.item));
            HierarchicalLayoutDialog.this.layouter.setMinimalNodeDistance(((Double)HierarchicalLayoutDialog.this.nodeDistanceField.getValue()).doubleValue());
            HierarchicalLayoutDialog.this.layouter.setMinimalEdgeDistance(((Double)HierarchicalLayoutDialog.this.edgeDistanceField.getValue()).doubleValue());
            HierarchicalLayoutDialog.this.layouter.setMinimalLayerDistance(((Double)HierarchicalLayoutDialog.this.layerDistanceField.getValue()).doubleValue());
            this.item = (String)HierarchicalLayoutDialog.this.routingList.getSelectedItem();
            HierarchicalLayoutDialog.this.layouter.setRoutingStyle(((Byte)HierarchicalLayoutDialog.this.routingHash.get(this.item)).byteValue());
            this.item = (String)HierarchicalLayoutDialog.this.layoutList.getSelectedItem();
            HierarchicalLayoutDialog.this.layouter.setLayoutStyle(((Byte)HierarchicalLayoutDialog.this.layoutHash.get(this.item)).byteValue());
            HierarchicalLayoutDialog.this.layouter.setRemoveFalseCrossings(HierarchicalLayoutDialog.this.removeFalseCrossingsBox.isSelected());
            HierarchicalLayoutDialog.this.dispose();
        }
    }
}

