/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.layout.Subgraph;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeList;
import y.layout.LayoutGraph;

public abstract class GroupingAlgorithm {
    LayoutGraph iGraph;
    static final int CONNECTED_TO = 1;
    static final int CONNECTED_FROM = 2;
    static final int CONNECTED_BI = 3;
    static final int NOT_CONNECTED = 0;
    HashMap iParentMap;
    HashMap iChildMap;

    public abstract Subgraph getNodeGrouping(int var1);

    public abstract Subgraph getClusterByNode(Node var1, Subgraph var2);

    public void useGraph(LayoutGraph layoutGraph) {
        this.iGraph = layoutGraph;
        this.iParentMap = new HashMap();
        this.iChildMap = new HashMap();
    }

    public void putNodeGrouping(Subgraph subgraph) {
        subgraph.reInsert();
    }

    public void putClusterByNode(Subgraph subgraph) {
        subgraph.reInsert();
    }

    void joinNodes(Node node, Node node2) {
        if (node == node2) {
            return;
        }
        System.out.println("Joining " + node2 + " to " + node);
        this.iParentMap.put(node2, node);
        NodeList nodeList = (NodeList)this.iChildMap.get(node);
        NodeList nodeList2 = (NodeList)this.iChildMap.get(node2);
        if (nodeList == null) {
            nodeList = new NodeList();
            this.iChildMap.put(node, nodeList);
        }
        nodeList.add((Object)node2);
        if (nodeList2 != null) {
            for (int i = 0; i < nodeList2.size(); ++i) {
                nodeList.add(nodeList2.elementAt(i));
            }
        }
        this.iChildMap.put(node2, null);
    }

    static int[][] gaConnected(LayoutGraph layoutGraph) {
        int n;
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n2 = layoutGraph.nodeCount();
        int[][] nArray = new int[n2][n2];
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n2; ++n) {
                nArray[i][n] = 0;
            }
        }
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            n = 0;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (nodeArray[i] == edgeCursor.edge().source()) {
                    n = i;
                    continue;
                }
                if (nodeArray[i] != edgeCursor.edge().target()) continue;
                n3 = i;
            }
            if (nArray[n][n3] == 2 || nArray[n3][n] == 1) {
                nArray[n3][n] = 3;
                nArray[n][n3] = 3;
            } else {
                nArray[n][n3] = 1;
                nArray[n3][n] = 2;
            }
            edgeCursor.next();
        }
        return nArray;
    }

    static int[] gaDegree(LayoutGraph layoutGraph, int[][] nArray) {
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n = layoutGraph.nodeCount();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (nArray[i][j] == 0) continue;
                int n2 = i;
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
        return nArray2;
    }

    static float[][] gaDistanceMatrix(LayoutGraph layoutGraph, int[][] nArray) {
        int n;
        int n2;
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n3 = layoutGraph.nodeCount();
        float[][] fArray = new float[n3][n3];
        System.out.println("Distance matrix: (" + n3 + " nodes)");
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                fArray[n2][n] = nArray[n2][n] != 0 ? 1 : 0;
            }
        }
        System.out.println("  filling distance matrix...");
        n2 = 1;
        for (n = 0; n < n3 && n2 != 0; ++n) {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                int n4 = Math.round((float)i / (float)n3 * 100.0f);
                System.out.print("\r    pass " + n + "/2(?): " + n4 + "%   ");
                for (int j = 0; j < n3; ++j) {
                    if ((double)fArray[i][j] == 0.0) continue;
                    for (int k = 0; k < n3; ++k) {
                        if ((double)fArray[j][k] == 0.0) continue;
                        float f = fArray[i][j] + fArray[j][k];
                        if (fArray[i][k] != 0.0f && !(f < fArray[i][k])) continue;
                        fArray[i][k] = f;
                        fArray[k][i] = f;
                        n2 = 1;
                    }
                }
            }
            System.out.println();
        }
        return fArray;
    }

    public static float[][] gaFastDistanceMatrix(LayoutGraph layoutGraph, int[][] nArray) {
        int n;
        int n2 = layoutGraph.nodeCount();
        float[][] fArray = new float[n2][n2];
        LinkedList[] linkedListArray = new LinkedList[n2];
        System.err.println("Fast Alg");
        Integer[] integerArray = new Integer[n2];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (nArray[n][i] == 0) continue;
                linkedListArray[n].add(integerArray[i]);
            }
        }
        System.err.println("Calculating all node distances..");
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            LinkedList linkedList2 = linkedListArray[i];
            if (linkedList2.getFirst() == null) {
                Arrays.fill(fArray[i], (float)(n2 + 2));
                continue;
            }
            Arrays.fill(fArray[i], (float)(n2 + 2));
            fArray[i][i] = 0.0f;
            Arrays.fill(blArray, false);
            linkedList.add(integerArray[i]);
            while (!linkedList.isEmpty()) {
                n = (Integer)linkedList.removeFirst();
                if (blArray[n]) continue;
                blArray[n] = true;
                LinkedList linkedList3 = linkedListArray[n];
                int n3 = (int)fArray[i][n];
                if (n < i) {
                    for (int j = 0; j < n2; ++j) {
                        int n4;
                        if ((int)fArray[n][j] == n2 + 2 || (n4 = n3 + (int)fArray[n][j]) > (int)fArray[i][j]) continue;
                        if ((int)fArray[n][j] == 1) {
                            blArray[j] = true;
                        }
                        fArray[i][j] = n4;
                    }
                    continue;
                }
                ListIterator listIterator = linkedList3.listIterator(0);
                while (listIterator.hasNext()) {
                    int n5 = (Integer)listIterator.next();
                    if (blArray[n5]) continue;
                    int n6 = (int)fArray[i][n5];
                    if (n3 == n2 + 2 || n6 <= n3 + 1) continue;
                    fArray[i][n5] = n3 + 1;
                    linkedList.addLast(integerArray[n5]);
                }
            }
        }
        System.err.println("..Done calculating all node distances.");
        return fArray;
    }
}

