/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.layout.GroupingAlgorithm;
import cytoscape.layout.Subgraph;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.LayoutGraph;

public class GroupWiseNodeGrouper
extends GroupingAlgorithm {
    HashMap iCNHash;
    HashMap iPNHash;
    int[][] iClusterMap;
    int[][] iConnected;
    static final String CSM_VERSION = "#CSM:0.6";

    public void useGraph(LayoutGraph layoutGraph) {
        super.useGraph(layoutGraph);
        this.iConnected = GroupWiseNodeGrouper.gaConnected(this.iGraph);
    }

    public Subgraph getNodeGrouping(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!this.getClusterMap()) {
            return null;
        }
        Subgraph subgraph = new Subgraph(this.iGraph);
        Node[] nodeArray = subgraph.getNodeArray();
        int n7 = subgraph.nodeCount();
        NodeList[] nodeListArray = new NodeList[n7];
        for (int i = 0; i < n7; ++i) {
            nodeListArray[i] = new NodeList();
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < n7; ++i) {
            vector.addElement(new Integer(i));
        }
        int[][] nArray = new int[n7][n7];
        for (n6 = 0; n6 < n7; ++n6) {
            for (n5 = 0; n5 < n7; ++n5) {
                nArray[n6][n5] = this.iConnected[n6][n5];
            }
        }
        System.out.println("Determining clusters...");
        n6 = n7 - n;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = Math.round((float)n5 / (float)n6 * 100.0f);
            System.out.print("   \r  " + n4 + "%");
            int n8 = (Integer)vector.elementAt(this.iClusterMap[n5][0]);
            n3 = (Integer)vector.elementAt(this.iClusterMap[n5][1]);
            vector.removeElementAt(this.iClusterMap[n5][1]);
            for (n2 = 0; n2 < n7; ++n2) {
                if (n2 == n8 || n2 == n3) continue;
                block0 : switch (nArray[n3][n2]) {
                    case 3: {
                        switch (nArray[n8][n2]) {
                            case 1: {
                                subgraph.createEdge(nodeArray[n2], nodeArray[n8]);
                                break;
                            }
                            case 2: {
                                subgraph.createEdge(nodeArray[n8], nodeArray[n2]);
                                break;
                            }
                            case 0: {
                                subgraph.createEdge(nodeArray[n2], nodeArray[n8]);
                                subgraph.createEdge(nodeArray[n8], nodeArray[n2]);
                            }
                        }
                        nArray[n2][n8] = 3;
                        nArray[n8][n2] = 3;
                        break;
                    }
                    case 1: {
                        switch (nArray[n8][n2]) {
                            case 2: {
                                subgraph.createEdge(nodeArray[n8], nodeArray[n2]);
                                nArray[n2][n8] = 3;
                                nArray[n8][n2] = 3;
                                break;
                            }
                            case 0: {
                                subgraph.createEdge(nodeArray[n8], nodeArray[n2]);
                                nArray[n8][n2] = 1;
                                nArray[n2][n8] = 2;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (nArray[n8][n2]) {
                            case 1: {
                                subgraph.createEdge(nodeArray[n2], nodeArray[n8]);
                                nArray[n2][n8] = 3;
                                nArray[n8][n2] = 3;
                                break block0;
                            }
                            case 0: {
                                subgraph.createEdge(nodeArray[n2], nodeArray[n8]);
                                nArray[n8][n2] = 2;
                                nArray[n2][n8] = 1;
                            }
                        }
                    }
                }
                nArray[n2][n3] = 0;
                nArray[n3][n2] = 0;
            }
            nodeListArray[n8].addLast((Object)nodeArray[n3]);
            for (n2 = 0; n2 < nodeListArray[n3].size(); ++n2) {
                nodeListArray[n8].addLast(nodeListArray[n3].elementAt(n2));
            }
        }
        System.out.println("\r  Done.");
        for (n5 = 0; n5 < vector.size(); ++n5) {
            n4 = (Integer)vector.elementAt(n5);
            double d = subgraph.getWidth(nodeArray[n4]) * Math.sqrt(nodeListArray[n4].size() + 1) * 6.0;
            subgraph.setSize(nodeArray[n4], d, d);
            for (n2 = 0; n2 < nodeListArray[n4].size(); ++n2) {
                subgraph.removeNode((Node)nodeListArray[n4].elementAt(n2));
            }
        }
        this.iCNHash = new HashMap();
        this.iPNHash = new HashMap();
        Node[] nodeArray2 = this.iGraph.getNodeArray();
        for (n4 = 0; n4 < n7; ++n4) {
            NodeList nodeList = new NodeList();
            for (n3 = 0; n3 < nodeListArray[n4].size(); ++n3) {
                nodeList.addLast((Object)subgraph.mapSubFullNode((Node)nodeListArray[n4].elementAt(n3)));
            }
            this.iCNHash.put(nodeArray2[n4], nodeList);
            this.iPNHash.put(nodeArray2[n4], nodeArray2[n4]);
        }
        Iterator iterator = this.iCNHash.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            NodeList nodeList = (NodeList)entry.getValue();
            for (n2 = 0; n2 < nodeList.size(); ++n2) {
                this.iPNHash.put(nodeList.elementAt(n2), entry.getKey());
            }
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            Iterator iterator2 = this.iPNHash.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                if (this.iPNHash.get(entry.getValue()) == entry.getValue()) continue;
                this.iPNHash.put(entry.getKey(), this.iPNHash.get(entry.getValue()));
                bl = true;
            }
        }
        return subgraph;
    }

    public Subgraph getClusterByNode(Node node, Subgraph subgraph) {
        NodeList nodeList = (NodeList)this.iCNHash.get(subgraph.mapSubFullNode(node));
        nodeList.addLast((Object)subgraph.mapSubFullNode(node));
        Subgraph subgraph2 = new Subgraph(this.iGraph, (YCursor)nodeList.nodes());
        NodeMap nodeMap = subgraph2.createNodeMap();
        Node[] nodeArray = this.iGraph.getNodeArray();
        int n = this.iGraph.nodeCount();
        NodeCursor nodeCursor = subgraph2.nodes();
        while (nodeCursor.ok()) {
            int n2;
            Node node2 = subgraph2.mapSubFullNode(nodeCursor.node());
            Node node3 = (Node)this.iPNHash.get(node2);
            for (n2 = 0; n2 < n && nodeArray[n2] != node2; ++n2) {
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < n; ++i) {
                if (this.iConnected[n2][i] == 0 || (Node)this.iPNHash.get(nodeArray[i]) == node3) continue;
                Node node4 = (Node)this.iPNHash.get(nodeArray[i]);
                double d3 = this.iGraph.getCenterX(node4) - this.iGraph.getCenterX(node3);
                double d4 = this.iGraph.getCenterY(node4) - this.iGraph.getCenterY(node3);
                double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                d += d3 / d5;
                d2 += d4 / d5;
            }
            if (d != 0.0 || d2 != 0.0) {
                double d6 = this.iGraph.getWidth(node3) * 3.0 * Math.sqrt(((NodeList)this.iCNHash.get(node3)).size() + 1);
                subgraph2.setCenter(nodeCursor.node(), d * d6, d2 * d6);
                nodeMap.setDouble((Object)nodeCursor.node(), 0.25);
            } else {
                subgraph2.setCenter(nodeCursor.node(), 10.0 * (Math.random() - 0.5), 10.0 * (Math.random() - 0.5));
                nodeMap.setDouble((Object)nodeCursor.node(), 1.0);
            }
            nodeCursor.next();
        }
        subgraph2.addDataProvider("Cytoscape:slug", (DataProvider)nodeMap);
        return subgraph2;
    }

    private boolean getClusterMap() {
        boolean bl = true;
        block4: while (bl) {
            Object[] objectArray = new Object[]{"Load From File", "Generate", "Cancel"};
            switch (JOptionPane.showOptionDialog(null, "Generation can take several minutes", "Cluster map required", -1, 2, null, objectArray, objectArray[0])) {
                case 0: {
                    bl = !this.cmLoad();
                    continue block4;
                }
                case 1: {
                    return this.cmGenerate();
                }
            }
            return false;
        }
        return true;
    }

    private boolean cmLoad() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Load cluster map");
        switch (jFileChooser.showOpenDialog(null)) {
            case 0: {
                File file = jFileChooser.getSelectedFile();
                try {
                    String string;
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                    if (!stringTokenizer.nextToken().equals(CSM_VERSION)) {
                        JOptionPane.showMessageDialog(null, "File incompatible with this version of Cytoscape", "Error Reading \"" + file.getName() + "\"", 0);
                        return false;
                    }
                    if (Integer.parseInt(stringTokenizer.nextToken()) != this.iGraph.nodeCount()) {
                        JOptionPane.showMessageDialog(null, "Wrong number of nodes found, expected " + this.iGraph.nodeCount(), "Error Reading \"" + file.getName() + "\"", 0);
                        return false;
                    }
                    this.iClusterMap = new int[this.iGraph.nodeCount() - 1][2];
                    int n = 0;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringTokenizer = new StringTokenizer(string);
                        this.iClusterMap[n][0] = Integer.parseInt(stringTokenizer.nextToken());
                        this.iClusterMap[n][1] = Integer.parseInt(stringTokenizer.nextToken());
                        ++n;
                    }
                    fileReader.close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), "Error Reading \"" + file.getName() + "\"", 0);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean cmGenerate() {
        float[][] fArray = this.getFastDistanceMatrix();
        this.iClusterMap = new int[this.iGraph.nodeCount() - 1][2];
        this.condenseDistanceMatrix(fArray);
        boolean bl = true;
        while (bl) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save cluster map to file");
            switch (jFileChooser.showSaveDialog(null)) {
                case 0: {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        boolean bl2 = true;
                        if (file.exists()) {
                            int n = JOptionPane.showConfirmDialog(null, "Overwrite " + file.getName() + "?", "File already exists", 0);
                            boolean bl3 = bl2 = n == 0;
                        }
                        if (bl2) {
                            FileWriter fileWriter = new FileWriter(file);
                            fileWriter.write("#CSM:0.6 " + this.iGraph.nodeCount() + "\n");
                            for (int i = 0; i < this.iGraph.nodeCount() - 1; ++i) {
                                fileWriter.write(this.iClusterMap[i][0] + " " + this.iClusterMap[i][1] + "\n");
                            }
                            fileWriter.close();
                            bl = false;
                            break;
                        }
                        bl = true;
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
                        bl = true;
                    }
                    break;
                }
                case -1: 
                case 1: {
                    int n = JOptionPane.showConfirmDialog(null, "Cluster map may need to be regenerated", "Confirm Cancel", 0);
                    bl = n == 1;
                }
            }
        }
        return true;
    }

    private float[][] getDistanceMatrix() {
        int n;
        int n2;
        Node[] nodeArray = this.iGraph.getNodeArray();
        int n3 = this.iGraph.nodeCount();
        float[][] fArray = new float[n3][n3];
        System.out.println("Distance matrix: (" + n3 + " nodes)");
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                fArray[n2][n] = this.iConnected[n2][n] != 0 ? 1 : 0;
            }
        }
        System.out.println("  filling distance matrix...");
        n2 = 1;
        for (n = 0; n < n3 && n2 != 0; ++n) {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                int n4 = Math.round((float)i / (float)n3 * 100.0f);
                System.out.print("\r    pass " + n + "/2(?): " + n4 + "%   ");
                for (int j = 0; j < n3; ++j) {
                    if ((double)fArray[i][j] == 0.0) continue;
                    for (int k = 0; k < n3; ++k) {
                        if ((double)fArray[j][k] == 0.0) continue;
                        float f = fArray[i][j] + fArray[j][k];
                        if (fArray[i][k] != 0.0f && !(f < fArray[i][k])) continue;
                        fArray[i][k] = f;
                        fArray[k][i] = f;
                        n2 = 1;
                    }
                }
            }
            System.out.println();
        }
        return fArray;
    }

    private float[][] getFastDistanceMatrix() {
        int n;
        int n2 = this.iGraph.nodeCount();
        float[][] fArray = new float[n2][n2];
        LinkedList[] linkedListArray = new LinkedList[n2];
        for (int i = 0; i < n2; ++i) {
            linkedListArray[i] = new LinkedList();
        }
        Integer[] integerArray = new Integer[n2];
        for (n = 0; n < n2; ++n) {
            integerArray[n] = new Integer(n);
        }
        for (n = 0; n < n2; ++n) {
            linkedListArray[n].clear();
            for (int i = 0; i < n2; ++i) {
                if (this.iConnected[n][i] == 0) continue;
                linkedListArray[n].add(integerArray[i]);
            }
        }
        System.err.println("Calculating all node distances..");
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            LinkedList linkedList2 = linkedListArray[i];
            if (linkedList2.getFirst() == null) {
                Arrays.fill(fArray[i], (float)(n2 + 2));
                continue;
            }
            Arrays.fill(fArray[i], (float)(n2 + 2));
            fArray[i][i] = 0.0f;
            Arrays.fill(blArray, false);
            linkedList.add(integerArray[i]);
            while (!linkedList.isEmpty()) {
                n = (Integer)linkedList.removeFirst();
                if (blArray[n]) continue;
                blArray[n] = true;
                LinkedList linkedList3 = linkedListArray[n];
                int n3 = (int)fArray[i][n];
                if (n < i) {
                    for (int j = 0; j < n2; ++j) {
                        int n4;
                        if ((int)fArray[n][j] == n2 + 2 || (n4 = n3 + (int)fArray[n][j]) > (int)fArray[i][j]) continue;
                        if ((int)fArray[n][j] == 1) {
                            blArray[j] = true;
                        }
                        fArray[i][j] = n4;
                    }
                    continue;
                }
                ListIterator listIterator = linkedList3.listIterator(0);
                while (listIterator.hasNext()) {
                    int n5 = (Integer)listIterator.next();
                    if (blArray[n5]) continue;
                    int n6 = (int)fArray[i][n5];
                    if (n3 == n2 + 2 || n6 <= n3 + 1) continue;
                    fArray[i][n5] = n3 + 1;
                    linkedList.addLast(integerArray[n5]);
                }
            }
        }
        System.err.println("..Done calculating all node distances.");
        return fArray;
    }

    private void condenseDistanceMatrix(float[][] fArray) {
        int n;
        int[] nArray = new int[this.iGraph.nodeCount()];
        for (n = 0; n < this.iGraph.nodeCount(); ++n) {
            nArray[n] = 1;
        }
        for (n = this.iGraph.nodeCount(); n > 1; --n) {
            System.out.println("Condensed Matrix: (" + (n - 1) + " nodes)");
            int n2 = 0;
            int n3 = 1;
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    if (!(fArray[i][j] < fArray[n2][n3])) continue;
                    n2 = i;
                    n3 = j;
                }
            }
            System.out.println("  combining nodes " + n2 + " and " + n3 + " (score: " + fArray[n2][n3] + ")");
            this.iClusterMap[this.iGraph.nodeCount() - n][0] = n2;
            this.iClusterMap[this.iGraph.nodeCount() - n][1] = n3;
            float[][] fArray2 = new float[n - 1][n - 1];
            int[] nArray2 = new int[n - 1];
            for (int i = 0; i < n; ++i) {
                int n4 = Math.round((float)i / (float)n * 100.0f);
                System.out.print("   \r  " + n4 + "%");
                if (i >= n3 && i < n - 1) {
                    nArray2[i] = nArray[i + 1];
                }
                if (i == n3) continue;
                int n5 = i > n3 ? i - 1 : i;
                nArray2[n5] = nArray[i];
                if (i == n2) {
                    int n6 = n5;
                    nArray2[n6] = nArray2[n6] + nArray[n3];
                }
                for (int j = i + 1; j < n; ++j) {
                    if (j == n3) continue;
                    int n7 = j > n3 ? j - 1 : j;
                    fArray2[n5][n7] = i == n2 && j != n2 ? ((float)nArray[n2] * fArray[j][n2] + (float)nArray[n3] * fArray[j][n3]) / (float)(nArray[n2] + nArray[n3]) : fArray[i][j];
                    fArray2[n7][n5] = fArray2[n5][n7];
                }
            }
            System.out.print("\r");
            fArray = fArray2;
            nArray = nArray2;
        }
    }
}

