/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.layout.EmbeddedLayouter;
import cytoscape.layout.GroupingAlgorithm;
import cytoscape.layout.Subgraph;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import y.base.Node;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.circular.CircularLayouter;
import y.layout.transformer.GraphTransformer;

public class GroupWiseLayouter
implements Layouter {
    GroupingAlgorithm iGrouper;

    public GroupWiseLayouter(GroupingAlgorithm groupingAlgorithm) {
        this.iGrouper = groupingAlgorithm;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (layoutGraph.nodeCount() >= 40) {
            int n = 0;
            while (n == 0) {
                boolean bl = false;
                String string = JOptionPane.showInputDialog(null, (Object)("Number of subgroups [1," + layoutGraph.nodeCount() + "]"));
                if (string != null) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "\"" + string + "\" is not an integer");
                        bl = true;
                    }
                } else {
                    return;
                }
                if ((bl || n > 0) && n <= layoutGraph.nodeCount()) continue;
                JOptionPane.showMessageDialog(null, string + " not in range [1," + layoutGraph.nodeCount() + "]");
                bl = true;
                n = 0;
            }
            this.iGrouper.useGraph(layoutGraph);
            Subgraph subgraph = this.iGrouper.getNodeGrouping(n);
            if (subgraph == null) {
                return;
            }
            float f = 0.0f;
            NodeCursor nodeCursor = subgraph.nodes();
            while (nodeCursor.ok()) {
                f += (float)subgraph.getWidth(nodeCursor.node());
                nodeCursor.next();
            }
            f /= (float)subgraph.nodeCount();
            f = (float)((double)f * (Math.sqrt(subgraph.nodeCount()) * 2.0));
            this.layoutGrouping((LayoutGraph)subgraph, f, f);
            this.iGrouper.putNodeGrouping(subgraph);
            nodeCursor = subgraph.nodes();
            while (nodeCursor.ok()) {
                YPoint yPoint = subgraph.getCenter(nodeCursor.node());
                Subgraph subgraph2 = this.iGrouper.getClusterByNode(nodeCursor.node(), subgraph);
                this.layoutCluster((LayoutGraph)subgraph2, (float)subgraph.getWidth(nodeCursor.node()), (float)subgraph.getHeight(nodeCursor.node()));
                Rectangle rectangle = subgraph2.getBoundingBox();
                GraphTransformer.translate((LayoutGraph)subgraph2, (double)(yPoint.getX() - (double)(rectangle.width / 2)), (double)(yPoint.getY() - (double)(rectangle.height / 2)));
                this.iGrouper.putClusterByNode(subgraph2);
                nodeCursor.next();
            }
        } else {
            CircularLayouter circularLayouter = new CircularLayouter();
            circularLayouter.doLayout(layoutGraph);
        }
    }

    private void layoutGrouping(LayoutGraph layoutGraph, float f, float f2) {
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n = layoutGraph.nodeCount();
        for (int i = 0; i < n; ++i) {
            layoutGraph.setCenter(nodeArray[i], 10.0 * (Math.random() - 0.5), 10.0 * (Math.random() - 0.5));
        }
        EmbeddedLayouter embeddedLayouter = new EmbeddedLayouter(f, f2);
        embeddedLayouter.doLayout(layoutGraph);
    }

    private void layoutCluster(LayoutGraph layoutGraph, float f, float f2) {
        EmbeddedLayouter embeddedLayouter = new EmbeddedLayouter(f, f2);
        embeddedLayouter.doLayout(layoutGraph);
    }
}

