/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import java.util.Vector;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.layout.LayoutGraph;
import y.layout.Layouter;
import y.layout.transformer.GraphTransformer;

public class EmbeddedLayouter
implements Layouter {
    private float iTWidth;
    private float iTHeight;
    private static final double LOG2 = Math.log(2.0);
    private boolean[][] connected;
    private int[] degree;

    public EmbeddedLayouter() {
        this.iTWidth = Float.NEGATIVE_INFINITY;
        this.iTHeight = Float.NEGATIVE_INFINITY;
    }

    public EmbeddedLayouter(float f, float f2) {
        this.iTWidth = f;
        this.iTHeight = f2;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        int n;
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n2 = layoutGraph.nodeCount();
        if (this.iTWidth == Float.NEGATIVE_INFINITY) {
            this.iTWidth = (float)layoutGraph.getBoundingBox().getWidth();
            this.iTHeight = (float)layoutGraph.getBoundingBox().getHeight();
        }
        if (n2 <= 1) {
            return;
        }
        this.connected = new boolean[n2][n2];
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            int n3 = 0;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (nodeArray[i] == edgeCursor.edge().source()) {
                    n3 = i;
                    continue;
                }
                if (nodeArray[i] != edgeCursor.edge().target()) continue;
                n = i;
            }
            this.connected[n3][n] = true;
            edgeCursor.next();
        }
        double d = 0.0;
        this.degree = new int[n2];
        for (n = 0; n < n2; ++n) {
            double d2 = layoutGraph.getWidth(nodeArray[n]) / Math.sqrt(2.0);
            if (d2 > d) {
                d = d2;
            }
            for (int i = 0; i < n2; ++i) {
                if (!this.connected[n][i]) continue;
                int n4 = n;
                this.degree[n4] = this.degree[n4] + 1;
            }
        }
        GraphTransformer graphTransformer = new GraphTransformer();
        graphTransformer.setOperation(3);
        this.doSpringLayoutFull(layoutGraph, 100, this.iTWidth, this.iTHeight);
        YRectangle yRectangle = this.getSize(layoutGraph, true);
        double d3 = (double)this.iTWidth / yRectangle.getWidth();
        double d4 = (double)this.iTHeight / yRectangle.getHeight();
        graphTransformer.setScaleFactor(d3 < d4 ? d3 : d4);
        graphTransformer.doLayoutCore(layoutGraph);
        this.doSpringLayoutBinned(layoutGraph, 200, this.iTWidth, this.iTHeight);
        yRectangle = this.getSize(layoutGraph, false);
        d3 = (double)this.iTWidth / yRectangle.getWidth();
        d4 = (double)this.iTHeight / yRectangle.getHeight();
        graphTransformer.setScaleFactor(d3 < d4 ? d3 : d4);
        graphTransformer.setScaleNodeSize(true);
        graphTransformer.doLayoutCore(layoutGraph);
        EdgeCursor edgeCursor2 = layoutGraph.edges();
        while (edgeCursor2.ok()) {
            layoutGraph.setPoints(edgeCursor2.edge(), new YPointPath());
            edgeCursor2.next();
        }
    }

    private void doSpringLayoutFull(LayoutGraph layoutGraph, int n, double d, double d2) {
        int n2;
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n3 = layoutGraph.nodeCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n3; ++i) {
            dArray[i] = layoutGraph.getCenterX(nodeArray[i]);
            dArray2[i] = layoutGraph.getCenterY(nodeArray[i]);
            dArray3[i] = layoutGraph.getWidth(nodeArray[i]) / Math.sqrt(2.0);
            if (!(dArray3[i] > d3)) continue;
            d3 = dArray3[i];
        }
        NodeMap nodeMap = (NodeMap)layoutGraph.getDataProvider((Object)"Cytoscape:slug");
        double d4 = Math.sqrt(d * d2 / (double)n3) / 2.0;
        for (n2 = 1; n2 <= n; ++n2) {
            double d5;
            double d6;
            double d7;
            double d8;
            int n4 = (int)((double)n2 / (double)n * 100.0);
            double d9 = 25.0 * Math.log(n2 + 1) / LOG2;
            double d10 = d / d9;
            double d11 = d2 / d9;
            double[] dArray4 = new double[n3];
            double[] dArray5 = new double[n3];
            int n5 = 0;
            while (n5 < n3) {
                double d12 = dArray[n5];
                d8 = dArray2[n5];
                for (int i = 0; i < n3; ++i) {
                    if (i == n5) continue;
                    d7 = d12 - dArray[i];
                    d6 = d8 - dArray2[i];
                    d5 = d7 * d7 + d6 * d6;
                    if (d5 < 1.0E-6) {
                        d5 = 1.0E-6;
                    }
                    double d13 = d4 + dArray3[n5] + dArray3[i];
                    double d14 = d13 * d13;
                    double d15 = d14 / d5;
                    int n6 = n5;
                    dArray4[n6] = dArray4[n6] + d15 * d7;
                    int n7 = n5;
                    dArray5[n7] = dArray5[n7] + d15 * d6;
                }
                int n8 = n5;
                dArray4[n8] = dArray4[n8] + (Math.random() - 0.5) / 100.0;
                int n9 = n5++;
                dArray5[n9] = dArray5[n9] + (Math.random() - 0.5) / 100.0;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                for (int i = 0; i < n3; ++i) {
                    if (!this.connected[i][n5]) continue;
                    double d16 = dArray[n5] - dArray[i];
                    double d17 = dArray2[n5] - dArray2[i];
                    d7 = Math.sqrt(d16 * d16 + d17 * d17);
                    d6 = d4 + dArray3[n5] + dArray3[i];
                    d5 = 16.0 * d7 / ((double)(this.degree[i] + this.degree[n5]) * d6);
                    int n10 = n5;
                    dArray4[n10] = dArray4[n10] - d16 * d5;
                    int n11 = n5;
                    dArray5[n11] = dArray5[n11] - d17 * d5;
                    int n12 = i;
                    dArray4[n12] = dArray4[n12] + d16 * d5;
                    int n13 = i;
                    dArray5[n13] = dArray5[n13] + d17 * d5;
                }
            }
            n5 = 0;
            while (n5 < n3) {
                double d18 = dArray4[n5];
                d8 = dArray5[n5];
                double d19 = Math.sqrt(d18 * d18 + d8 * d8);
                d18 = d10 * d18 / d19;
                d8 = d11 * d8 / d19;
                if (nodeMap != null) {
                    double d20 = nodeMap.getDouble((Object)nodeArray[n5]);
                    d18 *= d20;
                    d8 *= d20;
                }
                int n14 = n5;
                dArray[n14] = dArray[n14] + d18;
                int n15 = n5++;
                dArray2[n15] = dArray2[n15] + d8;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            layoutGraph.setCenter(nodeArray[n2], dArray[n2], dArray2[n2]);
        }
    }

    private void doSpringLayoutBinned(LayoutGraph layoutGraph, int n, double d, double d2) {
        int n2;
        int n3;
        int n4;
        int n5;
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n6 = layoutGraph.nodeCount();
        if (n6 <= 1) {
            return;
        }
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n6];
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n6; ++i) {
            dArray[i] = layoutGraph.getCenterX(nodeArray[i]);
            dArray2[i] = layoutGraph.getCenterY(nodeArray[i]);
            dArray3[i] = layoutGraph.getWidth(nodeArray[i]) / Math.sqrt(2.0);
            if (!(dArray3[i] > d3)) continue;
            d3 = dArray3[i];
        }
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            if (layoutGraph.getCenterX(nodeCursor.node()) < (double)f2) {
                f2 = (float)layoutGraph.getCenterX(nodeCursor.node());
            }
            if (layoutGraph.getCenterY(nodeCursor.node()) < (double)f) {
                f = (float)layoutGraph.getCenterY(nodeCursor.node());
            }
            nodeCursor.next();
        }
        nodeCursor = (NodeMap)layoutGraph.getDataProvider((Object)"Cytoscape:slug");
        double d4 = Math.sqrt((double)this.iTWidth * (double)this.iTHeight / (double)n6) / 2.0;
        int n7 = 1;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = (int)(layoutGraph.getWidth(nodeArray[n5]) * Math.sqrt(2.0));
            if (n4 <= n7) continue;
            n7 = n4;
        }
        if (d4 > (double)n7) {
            n7 = (int)d4;
        }
        n5 = (int)(this.iTWidth / (float)n7) + 1;
        n4 = (int)(this.iTHeight / (float)n7) + 1;
        Vector[][] vectorArray = new Vector[n5 + 2][n4 + 2];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = (int)(dArray[n3] - (double)f2) / n7;
            int n8 = (int)(dArray2[n3] - (double)f) / n7;
            if (vectorArray[n2 + 1][n8 + 1] == null) {
                vectorArray[n2 + 1][n8 + 1] = new Vector();
            }
            vectorArray[n2 + 1][n8 + 1].addElement(new Integer(n3));
        }
        for (n3 = 1; n3 <= n; ++n3) {
            int n9;
            double d5;
            int n10;
            n2 = (int)((double)n3 / (double)n * 100.0);
            double d6 = 50.0 * Math.log(n3 + 1) / LOG2;
            double d7 = (double)this.iTWidth / d6;
            double d8 = (double)this.iTHeight / d6;
            double[] dArray4 = new double[n6];
            double[] dArray5 = new double[n6];
            for (n10 = 0; n10 < n6; ++n10) {
                double d9 = dArray[n10];
                d5 = dArray2[n10];
                int n11 = (int)(d9 - (double)f2) / n7;
                int n12 = (int)(d5 - (double)f) / n7;
                for (n9 = -1; n9 <= 1; ++n9) {
                    for (int i = -1; i <= 1; ++i) {
                        Vector vector = vectorArray[n11 + n9 + 1][n12 + i + 1];
                        if (vector == null) continue;
                        for (int j = 0; j < vector.size(); ++j) {
                            double d10;
                            double d11;
                            int n13 = (Integer)vector.elementAt(j);
                            if (n13 == n10) continue;
                            double d12 = d9 - dArray[n13];
                            double d13 = d5 - dArray2[n13];
                            double d14 = d12 * d12 + d13 * d13;
                            if (d14 < 0.001) {
                                d14 = 0.001;
                            }
                            double d15 = 4.0 * (d11 = (d10 = d4 + dArray3[n10] + dArray3[n13]) * d10) > d14 ? d11 / d14 : 0.0;
                            int n14 = n10;
                            dArray4[n14] = dArray4[n14] + d15 * d12;
                            int n15 = n10;
                            dArray5[n15] = dArray5[n15] + d15 * d13;
                        }
                        int n16 = n10;
                        dArray4[n16] = dArray4[n16] * (0.5 * Math.random() + 0.75);
                        int n17 = n10;
                        dArray5[n17] = dArray5[n17] * (0.5 * Math.random() + 0.75);
                        int n18 = n10;
                        dArray4[n18] = dArray4[n18] + (Math.random() - 0.5) / 100.0;
                        int n19 = n10;
                        dArray5[n19] = dArray5[n19] + (Math.random() - 0.5) / 100.0;
                    }
                }
            }
            for (n10 = 0; n10 < n6; ++n10) {
                for (int i = 0; i < n6; ++i) {
                    if (!this.connected[i][n10]) continue;
                    double d16 = dArray[n10] - dArray[i];
                    double d17 = dArray2[n10] - dArray2[i];
                    double d18 = Math.sqrt(d16 * d16 + d17 * d17);
                    double d19 = d4 + dArray3[n10] + dArray3[i];
                    double d20 = 4.0 * d18 / ((double)(this.degree[i] + this.degree[n10]) * d19);
                    int n20 = n10;
                    dArray4[n20] = dArray4[n20] - d16 * d20;
                    int n21 = n10;
                    dArray5[n21] = dArray5[n21] - d17 * d20;
                    int n22 = i;
                    dArray4[n22] = dArray4[n22] + d16 * d20;
                    int n23 = i;
                    dArray5[n23] = dArray5[n23] + d17 * d20;
                }
            }
            for (n10 = 0; n10 < n6; ++n10) {
                int n24;
                int n25;
                double d21 = dArray4[n10];
                d5 = dArray5[n10];
                double d22 = Math.sqrt(d21 * d21 + d5 * d5);
                if (d22 < 1.0) {
                    d22 = 1.0;
                }
                d21 = d7 * d21 / d22;
                d5 = d8 * d5 / d22;
                if (nodeCursor != null) {
                    double d23 = nodeCursor.getDouble((Object)nodeArray[n10]);
                    d21 *= d23;
                    d5 *= d23;
                }
                n9 = n25 = (int)(dArray[n10] - (double)f2) / n7;
                int n26 = n24 = (int)(dArray2[n10] - (double)f) / n7;
                double d24 = dArray[n10] + d21;
                double d25 = dArray2[n10] + d5;
                if (d24 > (double)f2 && d24 < (double)(f2 + this.iTWidth)) {
                    dArray[n10] = d24;
                    n9 = (int)((d24 - (double)f2) / (double)n7);
                }
                if (d25 > (double)f && d25 < (double)(f + this.iTHeight)) {
                    dArray2[n10] = d25;
                    n26 = (int)((d25 - (double)f) / (double)n7);
                }
                if (n9 == n25 && n26 == n24) continue;
                Vector vector = vectorArray[n25 + 1][n24 + 1];
                for (int i = 0; i < vector.size(); ++i) {
                    if ((Integer)vector.elementAt(i) != n10) continue;
                    vector.removeElementAt(i);
                }
                Vector<Integer> vector2 = vectorArray[n9 + 1][n26 + 1];
                if (vector2 == null) {
                    Vector<Integer> vector3 = new Vector<Integer>();
                    vectorArray[n9 + 1][n26 + 1] = vector3;
                    vector2 = vector3;
                }
                vector2.addElement(new Integer(n10));
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            layoutGraph.setCenter(nodeArray[n3], dArray[n3], dArray2[n3]);
        }
    }

    private YRectangle getSize(LayoutGraph layoutGraph, boolean bl) {
        Node[] nodeArray = layoutGraph.getNodeArray();
        int n = layoutGraph.nodeCount();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                double d5 = layoutGraph.getCenterX(nodeArray[i]);
                double d6 = layoutGraph.getCenterY(nodeArray[i]);
                if (d5 < d3) {
                    d3 = d5;
                }
                if (d5 > d4) {
                    d4 = d5;
                }
                if (d6 < d) {
                    d = d6;
                }
                if (!(d6 > d2)) continue;
                d2 = d6;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d7 = layoutGraph.getCenterX(nodeArray[i]);
                double d8 = layoutGraph.getCenterY(nodeArray[i]);
                double d9 = layoutGraph.getWidth(nodeArray[i]) / 2.0;
                double d10 = layoutGraph.getHeight(nodeArray[i]) / 2.0;
                if (d7 - d9 < d3) {
                    d3 = d7 - d9;
                }
                if (d7 + d9 > d4) {
                    d4 = d7 + d9;
                }
                if (d8 - d10 < d) {
                    d = d8 - d10;
                }
                if (!(d8 + d10 > d2)) continue;
                d2 = d8 + d10;
            }
        }
        return new YRectangle(d3, d, d4 - d3, d2 - d);
    }
}

