/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.layout.GroupingAlgorithm;
import cytoscape.layout.Subgraph;
import java.util.Arrays;
import java.util.Comparator;
import y.base.Node;
import y.base.NodeList;
import y.base.YCursor;
import y.layout.LayoutGraph;

public class DegreeGrouper
extends GroupingAlgorithm {
    int[][] iConnected;
    int[] iDegree;
    float[][] iDm;

    public void useGraph(LayoutGraph layoutGraph) {
        super.useGraph(layoutGraph);
        this.iConnected = DegreeGrouper.gaConnected(this.iGraph);
        this.iDegree = DegreeGrouper.gaDegree(this.iGraph, this.iConnected);
        this.iDm = DegreeGrouper.gaDistanceMatrix(this.iGraph, this.iConnected);
    }

    public Subgraph getNodeGrouping(int n) {
        Node[] nodeArray = this.iGraph.getNodeArray();
        int n2 = this.iGraph.nodeCount();
        if (n >= n2) {
            return new Subgraph(this.iGraph);
        }
        IndexedDegree[] indexedDegreeArray = new IndexedDegree[n2];
        for (int i = 0; i < n2; ++i) {
            indexedDegreeArray[i] = new IndexedDegree(i, this.iDegree[i]);
        }
        Arrays.sort(indexedDegreeArray, new ByDegree());
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = indexedDegreeArray[i].index();
        }
        Subgraph subgraph = new Subgraph(this.iGraph);
        for (int i = n; i < n2; ++i) {
            int n3 = 0;
            for (int j = 1; j < n; ++j) {
                if (!(this.iDm[nArray[i]][nArray[j]] < this.iDm[nArray[i]][nArray[n3]])) continue;
                n3 = j;
            }
            this.joinNodes(nodeArray[nArray[n3]], nodeArray[nArray[i]]);
            subgraph.mergeNodes(subgraph.mapFullSubNode(nodeArray[nArray[n3]]), subgraph.mapFullSubNode(nodeArray[nArray[i]]));
        }
        return subgraph;
    }

    public Subgraph getClusterByNode(Node node, Subgraph subgraph) {
        NodeList nodeList = (NodeList)this.iChildMap.get(subgraph.mapSubFullNode(node));
        if (nodeList == null) {
            System.out.println("\n\n\nNULL!\n\n");
            nodeList = new NodeList();
        }
        Subgraph subgraph2 = new Subgraph(this.iGraph, (YCursor)nodeList.nodes());
        return subgraph2;
    }

    private class ByDegree
    implements Comparator {
        private ByDegree() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((IndexedDegree)object).degree();
            if (n2 > (n = ((IndexedDegree)object2).degree())) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }
    }

    private class IndexedDegree {
        int iIndex;
        int iDegree;

        public IndexedDegree(int n, int n2) {
            this.iIndex = n;
            this.iDegree = n2;
        }

        public int index() {
            return this.iIndex;
        }

        public int degree() {
            return this.iDegree;
        }
    }
}

