/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.undo.UndoableGraphHider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import y.base.EdgeCursor;
import y.base.GraphListener;
import y.base.Node;
import y.view.Graph2D;

public class AttributeLayout {
    protected CytoscapeWindow cytoscapeWindow;
    protected GraphObjAttributes nodeAttributes;
    protected GraphObjAttributes edgeAttributes;
    protected Graph2D graph;
    protected HashMap categoryNodes = new HashMap();
    UndoableGraphHider graphHider;
    String species;
    Properties props;
    String[] annotationAttributeNames;
    public static final int DO_LAYOUT = 0;
    public static final int CREATE_EDGES = 1;

    public AttributeLayout(CytoscapeWindow cytoscapeWindow) {
        this.cytoscapeWindow = cytoscapeWindow;
        this.nodeAttributes = cytoscapeWindow.getNodeAttributes();
        this.edgeAttributes = cytoscapeWindow.getEdgeAttributes();
        this.graph = cytoscapeWindow.getGraph();
        this.graphHider = cytoscapeWindow.getGraphHider();
    }

    protected String[] getAnnotationAttributes(GraphObjAttributes graphObjAttributes) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = graphObjAttributes.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = graphObjAttributes.getCategory(stringArray[i]);
            if (string == null || !string.equals("annotation")) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[0]);
    }

    public void doCallback(String string, int n) {
        if (n == 0) {
            int n2;
            Iterator iterator = this.graph.getGraphListeners();
            ArrayList<GraphListener> arrayList = new ArrayList<GraphListener>();
            while (iterator.hasNext()) {
                GraphListener graphListener = (GraphListener)iterator.next();
                arrayList.add(graphListener);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.graph.removeGraphListener((GraphListener)arrayList.get(n2));
            }
            this.performLayoutByAttribute(string);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.graph.addGraphListener((GraphListener)arrayList.get(n2));
            }
        } else if (n == 1) {
            this.createEdgesBetweenAllNodesWithSharedAttribute(string);
        }
    }

    public void createEdgesBetweenAllNodesWithSharedAttribute(String string) {
        this.deleteCategoryNodes();
        this.cytoscapeWindow.redrawGraph();
        String[] stringArray = this.getCurrentAttributeValues(string);
        this.addCategoryEdgesBetweenNodes(string);
        this.cytoscapeWindow.redrawGraph();
    }

    public void performLayoutByAttribute(String string) {
        this.deleteCategoryNodes();
        this.cytoscapeWindow.redrawGraph();
        String[] stringArray = this.getCurrentAttributeValues(string);
        this.createCategoryNodes(stringArray);
        this.graphHider.hideEdges();
        this.addCategoryEdges(string, stringArray);
        this.cytoscapeWindow.applyLayout(false);
        this.removeCategoryEdges(stringArray);
        this.graphHider.unhideEdges();
        this.cytoscapeWindow.redrawGraph();
    }

    protected void createCategoryNodes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Node node = this.graph.createNode(400.0, 100.0, 100.0, 100.0, string);
            this.nodeAttributes.set("layoutCategorizer", stringArray[i], "true");
            this.nodeAttributes.addNameMapping(stringArray[i], node);
            this.categoryNodes.put(stringArray[i], node);
        }
        this.nodeAttributes.setCategory("layoutCategorizer", "categorizer");
        this.cytoscapeWindow.redrawGraph();
    }

    protected void deleteCategoryNodes() {
        int n;
        GraphListener graphListener;
        if (this.categoryNodes == null || this.categoryNodes.size() == 0) {
            return;
        }
        String[] stringArray = this.categoryNodes.keySet().toArray(new String[0]);
        ArrayList<GraphListener> arrayList = new ArrayList<GraphListener>();
        if (stringArray.length > 0) {
            Iterator iterator = this.graph.getGraphListeners();
            while (iterator.hasNext()) {
                graphListener = (GraphListener)iterator.next();
                arrayList.add(graphListener);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.graph.removeGraphListener((GraphListener)arrayList.get(i));
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            graphListener = (Node)this.categoryNodes.get(stringArray[n]);
            this.graph.removeNode((Node)graphListener);
        }
        this.categoryNodes = new HashMap();
        if (stringArray.length > 0) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.graph.addGraphListener((GraphListener)arrayList.get(n));
            }
        }
    }

    protected void removeCategoryEdges(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Node node = (Node)this.categoryNodes.get(stringArray[i]);
            if (node == null) continue;
            EdgeCursor edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                this.graph.removeEdge(edgeCursor.edge());
                edgeCursor.next();
            }
        }
    }

    String[] getCurrentAttributeValues(String string) {
        Node[] nodeArray = this.graph.getNodeArray();
        Vector<String> vector = new Vector<String>();
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getNodeAttributes();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object;
            String string2 = this.cytoscapeWindow.getCanonicalNodeName(nodeArray[i]);
            if (string2 == null || (object = this.cytoscapeWindow.getNodeAttributes().getValue(string, string2)) == null) continue;
            String[] stringArray = GraphObjAttributes.unpackPossiblyCompoundStringAttributeValue(object);
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector.contains(stringArray[j])) continue;
                vector.add(stringArray[j]);
            }
        }
        return vector.toArray(new String[0]);
    }

    protected void addCategoryEdges(String string, String[] stringArray) {
        Node[] nodeArray = this.graph.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object;
            String string2 = this.cytoscapeWindow.getCanonicalNodeName(nodeArray[i]);
            if (string2 == null || (object = this.nodeAttributes.getValue(string, string2)) == null) continue;
            String[] stringArray2 = GraphObjAttributes.unpackPossiblyCompoundStringAttributeValue(object);
            for (int j = 0; j < stringArray2.length; ++j) {
                String string3 = stringArray2[j];
                Node node = (Node)this.categoryNodes.get(string3);
                this.graph.createEdge(node, nodeArray[i]);
            }
        }
    }

    protected void addCategoryEdgesBetweenNodes(String string) {
        Object object;
        String string2;
        int n;
        Node[] nodeArray;
        int n2;
        Object object2;
        Object object3;
        this.graph.firePreEvent();
        HashMap hashMap = this.nodeAttributes.getAttribute(string);
        if (hashMap == null) {
            return;
        }
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = hashMap.get(stringArray[i]);
            object2 = ((Vector)object3).toArray(new String[0]);
            for (n2 = 0; n2 < ((String[])object2).length; ++n2) {
                if (vector.contains(object2[n2])) continue;
                vector.add(object2[n2]);
            }
        }
        String[] stringArray2 = vector.toArray(new String[0]);
        object3 = this.graph.getNodeArray();
        object2 = new HashMap();
        for (n2 = 0; n2 < ((V)object3).length; ++n2) {
            String string3 = this.cytoscapeWindow.getCanonicalNodeName((Node)object3[n2]);
            if (string3 == null || (nodeArray = this.nodeAttributes.getValue(string, string3)) == null) continue;
            String[] stringArray3 = GraphObjAttributes.unpackPossiblyCompoundStringAttributeValue(nodeArray);
            for (n = 0; n < stringArray3.length; ++n) {
                string2 = stringArray3[n];
                if (!((HashMap)object2).containsKey(string2)) {
                    ((HashMap)object2).put(string2, new Vector());
                }
                object = (Vector)((HashMap)object2).get(string2);
                ((Vector)object).add(object3[n2]);
            }
        }
        String[] stringArray4 = ((HashMap)object2).keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray4.length; ++i) {
            nodeArray = ((Vector)((HashMap)object2).get(stringArray4[i])).toArray(new Node[0]);
            for (int j = 0; j < nodeArray.length; ++j) {
                for (n = j + 1; n < nodeArray.length; ++n) {
                    if (n >= nodeArray.length) continue;
                    string2 = this.graph.createEdge(nodeArray[j], nodeArray[n]);
                    object = "node_" + j;
                    String string4 = "node_" + n;
                    String string5 = (String)object + " (" + stringArray4[i] + ") " + string4;
                    this.edgeAttributes.set("eInteraction", string5, string);
                    this.edgeAttributes.set(string, string5, stringArray4[i]);
                    this.edgeAttributes.addNameMapping(string5, string2);
                }
            }
        }
        this.graph.firePostEvent();
    }
}

