/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.jarLoader;

import cytoscape.CytoscapeWindow;
import cytoscape.jarLoader.JarClassLoader;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JarPluginLoaderAction
extends AbstractAction {
    protected CytoscapeWindow cytoscapeWindow;
    protected File file;

    JarPluginLoaderAction(CytoscapeWindow cytoscapeWindow) {
        super("Plugin Jar File");
        this.cytoscapeWindow = cytoscapeWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.getFile()) {
            return;
        }
        String string = this.file.getPath();
        System.out.println("Chose: " + string);
        try {
            JarClassLoader jarClassLoader = new JarClassLoader("file:" + string, this.cytoscapeWindow);
            jarClassLoader.loadRelevantClasses();
        }
        catch (Exception exception) {
            System.err.println("Error 1: " + exception.getMessage());
        }
    }

    private boolean getFile() {
        JFileChooser jFileChooser = new JFileChooser(this.cytoscapeWindow.getCurrentDirectory());
        jFileChooser.setDialogTitle("Load Plugin from Jar");
        switch (jFileChooser.showOpenDialog(null)) {
            case 0: {
                this.file = jFileChooser.getSelectedFile();
                try {
                    FileReader fileReader = new FileReader(this.file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    fileReader.close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), "Error Reading \"" + this.file.getName() + "\"", 0);
                    return false;
                }
                this.cytoscapeWindow.setCurrentDirectory(this.file);
                return true;
            }
        }
        return false;
    }
}

