/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.jarLoader;

import cytoscape.CytoscapeWindow;
import cytoscape.jarLoader.JarClassLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class JarPluginDirectoryAction
extends AbstractAction {
    protected CytoscapeWindow cytoscapeWindow;
    protected File file;
    protected boolean ready = false;

    JarPluginDirectoryAction(CytoscapeWindow cytoscapeWindow) {
        super("Plugin Jar Directory");
        this.cytoscapeWindow = cytoscapeWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.getDir()) {
            return;
        }
        this.ready = true;
        this.tryDirectory();
    }

    public void setDir(String string) {
        try {
            this.file = new File(string);
            if (this.file.isDirectory()) {
                this.ready = true;
            } else {
                String string2 = this.file.getParent();
                this.file = new File(string2);
                this.ready = this.file.isDirectory();
            }
        }
        catch (Exception exception) {
            System.err.println("Not file: " + string + "\n" + exception.getMessage());
            this.ready = false;
        }
    }

    public void tryDirectory() {
        if (!this.ready) {
            return;
        }
        String[] stringArray = this.file.list();
        String string = "";
        if (!this.file.getPath().endsWith("/")) {
            string = "/";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".jar")) continue;
            String string2 = this.file.getPath() + string + stringArray[i];
            try {
                JarClassLoader jarClassLoader = new JarClassLoader("file:" + string2, this.cytoscapeWindow);
                jarClassLoader.loadRelevantClasses();
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error loading jar: " + exception.getMessage());
            }
        }
    }

    private boolean getDir() {
        JFileChooser jFileChooser = new JFileChooser(this.cytoscapeWindow.getCurrentDirectory());
        jFileChooser.setDialogTitle("Load Plugin from Jar Directory");
        jFileChooser.setFileSelectionMode(1);
        switch (jFileChooser.showOpenDialog(null)) {
            case 0: {
                this.file = jFileChooser.getSelectedFile();
                this.cytoscapeWindow.setCurrentDirectory(this.file);
                return true;
            }
        }
        return false;
    }
}

