/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.jarLoader;

import cytoscape.CytoscapeWindow;
import cytoscape.jarLoader.JarPluginDirectoryAction;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

public class JarLoaderCommandLineParser {
    private boolean activePathParametersPresent = false;
    JarPluginDirectoryAction jpda;
    CytoscapeWindow cw;

    public JarLoaderCommandLineParser(String[] stringArray, CytoscapeWindow cytoscapeWindow) {
        this.cw = cytoscapeWindow;
        this.jpda = new JarPluginDirectoryAction(cytoscapeWindow);
        this.parseArgs(stringArray);
    }

    public void usage() {
        System.err.println("jarLoader command line arguments:");
        System.err.println("    --JLD  <string>   directory for .jar files");
        System.err.println("    --JLH             prints this help");
    }

    private void parseArgs(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("JLD", 1, null, 0), new LongOpt("JLH", 0, null, 1)};
        Getopt getopt = new Getopt("jarLoader", stringArray, "", longOptArray);
        getopt.setOpterr(false);
        boolean bl = false;
        block4: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 0: {
                    String string = getopt.getOptarg();
                    System.out.println("Command line to load jars from " + string);
                    this.jpda.setDir(string);
                    this.jpda.tryDirectory();
                    continue block4;
                }
                case 1: {
                    String string = getopt.getOptarg();
                    bl = true;
                    continue block4;
                }
            }
        }
        if (bl) {
            this.usage();
        }
    }
}

