/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.jarLoader;

import cytoscape.AbstractPlugin;
import cytoscape.CytoscapeWindow;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JMenu;

public class JarClassLoader
extends URLClassLoader {
    private String urlString;
    private URL url;
    private CytoscapeWindow cytoscapeWindow;

    public JarClassLoader(String string, CytoscapeWindow cytoscapeWindow) throws MalformedURLException {
        super(new URL[]{new URL(string)}, JarClassLoader.class.getClassLoader());
        this.urlString = string;
        this.cytoscapeWindow = cytoscapeWindow;
        this.url = new URL("jar", "", string + "!/");
    }

    public void loadRelevantClasses() {
        block6: {
            JarURLConnection jarURLConnection = null;
            try {
                jarURLConnection = (JarURLConnection)this.url.openConnection();
                if (jarURLConnection == null) {
                    throw new Exception("null URL Connection");
                }
                JarFile jarFile = jarURLConnection.getJarFile();
                if (jarFile == null) {
                    throw new Exception("null JarFile from URL");
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                if (enumeration == null) {
                    throw new Exception("null jar entries");
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (enumeration.hasMoreElements()) {
                    ++n;
                    JarEntry jarEntry = enumeration.nextElement();
                    String string = ((Object)jarEntry).toString();
                    if (!string.endsWith(".class")) continue;
                    ++n2;
                    String string2 = string.replaceAll("\\.class$", "");
                    if (!this.isClassPlugin(string2)) continue;
                    ++n3;
                    this.invokePlugin(string2);
                }
                System.out.println(".jar summary:  entries=" + n + " classes=" + n2 + " plugins=" + n3);
            }
            catch (Exception exception) {
                System.err.println("Error thrown: " + exception.getMessage());
                if (jarURLConnection != null) break block6;
                System.out.println("uc is null 4e");
            }
        }
    }

    public void invokeClass(String string, String[] stringArray) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = this.loadClass(string);
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.setAccessible(true);
        int n = method.getModifiers();
        if (method.getReturnType() != Void.TYPE || !Modifier.isStatic(n) || !Modifier.isPublic(n)) {
            throw new NoSuchMethodException("main");
        }
        try {
            method.invoke(null, new Object[]{stringArray});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void invokePlugin(String string) {
        try {
            String string2;
            if (!this.isClassPlugin(string)) {
                throw new Exception("not plugin: " + string);
            }
            Class<?> clazz = this.loadClass(string);
            Class[] classArray = new Class[]{this.cytoscapeWindow.getClass()};
            Object[] objectArray = new Object[]{this.cytoscapeWindow};
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            System.out.println("Loaded plugin: " + string);
            JMenu jMenu = this.cytoscapeWindow.getOperationsMenu();
            if (jMenu.getItemCount() > 0 && (string2 = jMenu.getItem(0).getText()).equals("No plugins loaded")) {
                jMenu.remove(0);
            }
        }
        catch (Exception exception) {
            System.err.println("Error instantiating plugin: " + exception.getMessage());
        }
    }

    public boolean isClassPlugin(String string) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class clazz;
        Class<?> clazz2 = this.loadClass(string);
        Class clazz3 = clazz = AbstractPlugin.class;
        return clazz.isAssignableFrom(clazz2);
    }

    public Class getClass(String string) throws ClassNotFoundException {
        return this.findClass(string);
    }
}

