/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.filters.Filter;
import cytoscape.filters.TopologyFilter;
import cytoscape.filters.TopologyOnePassFilter;
import cytoscape.filters.dialogs.BoolPanel;
import cytoscape.filters.dialogs.FilterDialog;
import cytoscape.filters.dialogs.MutableBoolean;
import javax.swing.JPanel;
import javax.swing.JTextField;
import y.view.Graph2D;

public class TopologyDialog
extends FilterDialog {
    public static String DESC = "Select nodes that have the indicated number of neighbors within the indicated depth.";
    int nNeighbors;
    JTextField nNeighborsField;
    int maxDepth;
    JTextField maxDepthField;
    MutableBoolean stabilize = new MutableBoolean(true);

    public TopologyDialog() {
        super(FilterDialog.TOPOLOGY);
        this.panel.setName("Topology");
        this.panel.add(TopologyDialog.createDescPanel(DESC));
        this.nNeighborsField = new JTextField(4);
        JPanel jPanel = FilterDialog.createFieldPanel("Minimum Number of Neighbors", this.nNeighborsField);
        this.maxDepthField = new JTextField(4);
        JPanel jPanel2 = FilterDialog.createFieldPanel("Within Depth", this.maxDepthField);
        JPanel jPanel3 = FilterDialog.createSubPanel("Requirements", new JPanel[]{jPanel, jPanel2});
        JPanel jPanel4 = FilterDialog.createSubPanel("Options", new JPanel[]{FilterDialog.createFieldPanel("Apply Filter Until Stable Point?", new BoolPanel(this.stabilize, "Yes", "No (Only Once)").getPanel())});
        this.panel.add(jPanel3);
        this.panel.add(jPanel4);
    }

    public boolean setValid() {
        boolean bl = true;
        String string = "should be a positive integer";
        this.clearInvalidMsg();
        this.nNeighbors = FilterDialog.parsePosInt(this.nNeighborsField.getText());
        if (this.nNeighbors == -1) {
            bl = false;
            this.nNeighbors = 1;
            this.addInvalidMsg("Number of Neighbors", string);
        }
        this.maxDepth = FilterDialog.parsePosInt(this.maxDepthField.getText());
        if (this.maxDepth == -1) {
            bl = false;
            this.maxDepth = 1;
            this.addInvalidMsg("Depth", string);
        }
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        Filter filter = this.stabilize.booleanValue() ? new TopologyFilter(graph2D, this.nNeighbors, this.maxDepth) : new TopologyOnePassFilter(graph2D, this.nNeighbors, this.maxDepth);
        return filter;
    }
}

