/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.Filter;
import cytoscape.filters.NodeTypeFilter;
import cytoscape.filters.dialogs.FilterDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import y.view.Graph2D;

public class NodeTypeDialog
extends FilterDialog {
    public static String DESC = "Select nodes that are of any of the selected types.";
    GraphObjAttributes nodeAttributes;
    JList typeList;

    public NodeTypeDialog(GraphObjAttributes graphObjAttributes) {
        super(FilterDialog.NODE_TYPE);
        this.panel.setName("Node Type");
        this.panel.add(NodeTypeDialog.createDescPanel(DESC));
        this.nodeAttributes = graphObjAttributes;
        this.typeList = new JList<String>(this.getTypes());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.typeList, "Center");
        JPanel jPanel2 = FilterDialog.createSubPanel("Node Types", new JPanel[]{jPanel});
        this.panel.add(jPanel2);
    }

    public boolean setValid() {
        boolean bl = true;
        this.clearInvalidMsg();
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        Object[] objectArray = this.typeList.getSelectedValues();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        NodeTypeFilter nodeTypeFilter = new NodeTypeFilter(graph2D, this.nodeAttributes, stringArray);
        return nodeTypeFilter;
    }

    public String[] getTypes() {
        return new String[]{"gene", "compound", "reaction"};
    }
}

