/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.FilterDialogClient;
import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.filters.Filter;
import cytoscape.filters.dialogs.AttributeDialog;
import cytoscape.filters.dialogs.CenterDialog;
import cytoscape.filters.dialogs.CombinationDialog;
import cytoscape.filters.dialogs.ExpressionDialog;
import cytoscape.filters.dialogs.FilterDialog;
import cytoscape.filters.dialogs.InteractionDialog;
import cytoscape.filters.dialogs.NodeTypeDialog;
import cytoscape.filters.dialogs.TopologyDialog;
import cytoscape.undo.UndoableGraphHider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import y.view.Graph2D;

public class MainFilterDialog
extends JDialog {
    FilterDialogClient client;
    MainFilterDialog thisDialog;
    Frame parent;
    Graph2D graph;
    GraphObjAttributes nodeAttributes;
    GraphObjAttributes edgeAttributes;
    ExpressionData expressionData;
    UndoableGraphHider graphHider;
    String[] interactionTypes;
    Vector dialogs = new Vector();
    int[] types = new int[]{FilterDialog.TOPOLOGY, FilterDialog.CENTER, FilterDialog.INTERACTION, FilterDialog.NODE_TYPE, FilterDialog.EXPRESSION, FilterDialog.ATTRIBUTE, FilterDialog.COMBINATION};
    int[] counters;
    JTabbedPane tabbedPane;

    public MainFilterDialog(FilterDialogClient filterDialogClient, Frame frame, Graph2D graph2D, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, ExpressionData expressionData, UndoableGraphHider undoableGraphHider, String[] stringArray) {
        super(frame, false);
        this.setTitle("Filters");
        this.thisDialog = this;
        this.client = filterDialogClient;
        this.parent = frame;
        this.graph = graph2D;
        this.expressionData = expressionData;
        this.nodeAttributes = graphObjAttributes;
        this.edgeAttributes = graphObjAttributes2;
        this.graphHider = undoableGraphHider;
        this.interactionTypes = stringArray;
        this.initCounters();
        this.tabbedPane = new JTabbedPane();
        this.initFilterDialogs();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Select");
        jPanel.add(jButton);
        jButton.addActionListener(new SelectAction());
        JButton jButton2 = new JButton("Dismiss");
        jPanel.add(jButton2);
        jButton2.addActionListener(new DismissAction());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton3 = new JButton("New");
        jPanel2.add(jButton3);
        jButton3.addActionListener(new newFilterAction());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "West");
        jPanel3.add((Component)jPanel, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.tabbedPane, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.setContentPane(jPanel4);
        this.pack();
        this.setLocation(frame.getLocationOnScreen());
        this.pack();
        this.setVisible(true);
    }

    private void initCounters() {
        int n = this.types.length;
        this.counters = new int[n];
        for (int i = 0; i < n; ++i) {
            this.counters[i] = 0;
        }
    }

    private int getNextIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < this.counters.length; ++i) {
            n2 += this.counters[i];
            if (this.types[i] != n) continue;
            int n3 = i;
            this.counters[n3] = this.counters[n3] + 1;
            break;
        }
        return n2;
    }

    private int getCounter(int n) {
        int n2 = 0;
        for (int i = 0; i < this.counters.length; ++i) {
            if (this.types[i] != n) continue;
            n2 = this.counters[i];
            break;
        }
        return n2;
    }

    private int addFilterDialog(int n) {
        FilterDialog filterDialog = n == FilterDialog.EXPRESSION ? new ExpressionDialog(this.expressionData, this.nodeAttributes) : (n == FilterDialog.COMBINATION ? new CombinationDialog(this.dialogs) : (n == FilterDialog.CENTER ? new CenterDialog(this.parent, this.graph) : (n == FilterDialog.INTERACTION ? new InteractionDialog(this.edgeAttributes, this.interactionTypes) : (n == FilterDialog.NODE_TYPE ? new NodeTypeDialog(this.nodeAttributes) : (n == FilterDialog.ATTRIBUTE ? new AttributeDialog(this.nodeAttributes) : new TopologyDialog())))));
        int n2 = this.getNextIndex(n);
        this.dialogs.add(n2, filterDialog);
        JPanel jPanel = filterDialog.getPanel();
        jPanel.setName(jPanel.getName() + " " + this.getCounter(n));
        this.tabbedPane.add((Component)jPanel, n2);
        return n2;
    }

    private void initFilterDialogs() {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.expressionData == null && this.types[i] == FilterDialog.EXPRESSION) continue;
            this.addFilterDialog(this.types[i]);
        }
    }

    private void updateCombinations(int n) {
        int n2 = this.getCounter(FilterDialog.COMBINATION);
        int n3 = this.dialogs.size() - n2;
        for (int i = 0; i < n2; ++i) {
            CombinationDialog combinationDialog = (CombinationDialog)this.dialogs.elementAt(i + n3);
            combinationDialog.update(n);
        }
    }

    public class newFilterAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MainFilterDialog.this.tabbedPane.getSelectedIndex();
            if (n != -1) {
                FilterDialog filterDialog = (FilterDialog)MainFilterDialog.this.dialogs.elementAt(n);
                int n2 = MainFilterDialog.this.addFilterDialog(filterDialog.getType());
                if (!filterDialog.isType(FilterDialog.COMBINATION)) {
                    MainFilterDialog.this.updateCombinations(n2);
                }
                MainFilterDialog.this.tabbedPane.setSelectedIndex(n2);
            }
        }
    }

    public class SelectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MainFilterDialog.this.tabbedPane.getSelectedIndex();
            if (n != -1) {
                FilterDialog filterDialog = (FilterDialog)MainFilterDialog.this.dialogs.elementAt(n);
                if (!filterDialog.setValid()) {
                    JOptionPane.showMessageDialog(MainFilterDialog.this.parent, "<html>" + filterDialog.getInvalidMsg() + "</html>");
                } else {
                    Filter filter = filterDialog.getFilter(MainFilterDialog.this.graph);
                    filter.select();
                }
            }
            MainFilterDialog.this.client.redrawGraph();
        }
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFilterDialog.this.thisDialog.dispose();
        }
    }
}

