/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.Filter;
import cytoscape.filters.InteractionFilter;
import cytoscape.filters.dialogs.FilterDialog;
import cytoscape.filters.dialogs.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import y.view.Graph2D;

public class InteractionDialog
extends FilterDialog {
    public static String DESC = "Select nodes that are in any interaction of the selected types.";
    GraphObjAttributes edgeAttributes;
    JList typeList;
    String[] interactionTypes;
    RadioPanel search;

    public InteractionDialog(GraphObjAttributes graphObjAttributes, String[] stringArray) {
        super(FilterDialog.INTERACTION);
        this.panel.setName("Interaction");
        this.panel.add(InteractionDialog.createDescPanel(DESC));
        this.edgeAttributes = graphObjAttributes;
        this.interactionTypes = stringArray;
        this.search = new RadioPanel(new String[]{"source", "target", "both"}, "both");
        JPanel jPanel = FilterDialog.createSubPanel("Search in", new JPanel[]{this.search.getPanel()});
        this.panel.add(jPanel);
        this.typeList = new JList<String>(this.getTypes());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.typeList, "Center");
        JPanel jPanel3 = FilterDialog.createSubPanel("Interaction Types", new JPanel[]{jPanel2});
        this.panel.add(jPanel3);
    }

    public boolean setValid() {
        boolean bl = true;
        this.clearInvalidMsg();
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        Object[] objectArray = this.typeList.getSelectedValues();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        InteractionFilter interactionFilter = new InteractionFilter(graph2D, this.edgeAttributes, stringArray, this.search.toString());
        return interactionFilter;
    }

    public String[] getTypes() {
        return this.interactionTypes;
    }
}

