/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.filters.Filter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import y.view.Graph2D;

public abstract class FilterDialog {
    public static int TOPOLOGY = 1;
    public static int EXPRESSION = 2;
    public static int COMBINATION = 3;
    public static int CENTER = 4;
    public static int INTERACTION = 5;
    public static int NODE_TYPE = 6;
    public static int PATHWAY = 7;
    public static int EDGE_TYPE = 8;
    public static int ATTRIBUTE = 9;
    private int type;
    private String invalidMsg;
    protected JPanel panel = new JPanel();
    private JPanel framePanel;

    public FilterDialog(int n) {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.clearInvalidMsg();
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isType(int n) {
        return this.type == n;
    }

    public JPanel getPanel() {
        this.framePanel = new JPanel();
        this.framePanel.setLayout(new BorderLayout());
        this.framePanel.add((Component)this.panel, "North");
        this.framePanel.setName(this.panel.getName());
        return this.framePanel;
    }

    public String getName() {
        return this.framePanel.getName();
    }

    public String getInvalidMsg() {
        if (this.invalidMsg.equals("")) {
            return "Valid input";
        }
        return "<ul>" + this.invalidMsg + "</ul>";
    }

    protected void clearInvalidMsg() {
        this.invalidMsg = "";
    }

    protected void addInvalidMsg(String string, String string2) {
        this.addInvalidMsg("<tt>" + string + "</tt> " + string2 + ".");
    }

    protected void addInvalidMsg(String string) {
        this.invalidMsg = this.invalidMsg + "<li>" + string + "</li>";
    }

    public abstract boolean setValid();

    public abstract Filter getFilter(Graph2D var1);

    public static int parsePosInt(String string) {
        int n;
        int n2 = n = -1;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
                if (n2 < 0) {
                    n2 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static double parseDouble(String string) {
        double d;
        double d2 = d = -1.0;
        if (string != null) {
            try {
                d2 = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = d;
            }
        }
        return d2;
    }

    public static JPanel createFieldPanel(String string, JComponent jComponent) {
        if (!string.equals("")) {
            string = " " + string + ": ";
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("SansSerif", 0, 11));
        jLabel.setLabelFor(jComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel.add(jLabel);
        jPanel.add(jComponent);
        return jPanel;
    }

    public static JPanel createFieldPanel(JComponent jComponent) {
        return FilterDialog.createFieldPanel("", jComponent);
    }

    public static JPanel createSubPanel(String string, JPanel[] jPanelArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        for (int i = 0; i < jPanelArray.length; ++i) {
            jPanel.add(jPanelArray[i]);
        }
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitleColor(Color.GRAY);
        titledBorder.setTitleFont(new Font("SansSerif", 1, 11));
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return jPanel;
    }

    protected static JPanel createDescPanel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Serif", 2, 11));
        jLabel.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        return jPanel;
    }
}

