/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.filters.ExpressionFilter;
import cytoscape.filters.Filter;
import cytoscape.filters.dialogs.BoolPanel;
import cytoscape.filters.dialogs.FilterDialog;
import cytoscape.filters.dialogs.MutableBoolean;
import javax.swing.JPanel;
import javax.swing.JTextField;
import y.view.Graph2D;

public class ExpressionDialog
extends FilterDialog {
    public static String DESC = "Select all afffected nodes as well as unaffected nodes which have the indicated number of affected neighbors within the indicated depth.";
    ExpressionData expressionData;
    GraphObjAttributes nodeAttributes;
    double cutoff;
    JTextField cutoffField;
    int nConds;
    JTextField nCondsField;
    int nNeighbors;
    JTextField nNeighborsField;
    int maxDepth;
    JTextField maxDepthField;
    MutableBoolean cutoffLess = new MutableBoolean(false);
    MutableBoolean hideSingletons = new MutableBoolean(false);
    MutableBoolean useRatio = new MutableBoolean(false);

    public ExpressionDialog(ExpressionData expressionData, GraphObjAttributes graphObjAttributes) {
        super(FilterDialog.EXPRESSION);
        this.panel.setName("Expression");
        this.panel.add(ExpressionDialog.createDescPanel(DESC));
        this.expressionData = expressionData;
        this.nodeAttributes = graphObjAttributes;
        JPanel jPanel = FilterDialog.createFieldPanel("Cutoff Value", new BoolPanel(this.cutoffLess, "smaller than", "greater than").getPanel());
        this.cutoffField = new JTextField(4);
        JPanel jPanel2 = FilterDialog.createFieldPanel(this.cutoffField);
        JPanel jPanel3 = FilterDialog.createFieldPanel("Compare Value With", new BoolPanel(this.useRatio, "Ratio", "Significance").getPanel());
        this.nCondsField = new JTextField(4);
        JPanel jPanel4 = FilterDialog.createFieldPanel("Minimum Number of Meeting Conditions", this.nCondsField);
        JPanel jPanel5 = FilterDialog.createSubPanel("Definition of Affected Nodes", new JPanel[]{jPanel, jPanel2, jPanel3, jPanel4});
        this.panel.add(jPanel5);
        this.nNeighborsField = new JTextField(4);
        JPanel jPanel6 = FilterDialog.createFieldPanel("Minimum Number of Affected Neighbors", this.nNeighborsField);
        this.maxDepthField = new JTextField(4);
        JPanel jPanel7 = FilterDialog.createFieldPanel("Within Depth", this.maxDepthField);
        JPanel jPanel8 = FilterDialog.createFieldPanel("Hide Singletons?", new BoolPanel(this.hideSingletons, "Yes", "No").getPanel());
        JPanel jPanel9 = FilterDialog.createSubPanel("Requirements for Unaffected Nodes", new JPanel[]{jPanel6, jPanel7});
        JPanel jPanel10 = FilterDialog.createSubPanel("Options", new JPanel[]{jPanel8});
        this.panel.add(jPanel9);
        this.panel.add(jPanel10);
    }

    public boolean setValid() {
        boolean bl = true;
        String string = "should be a positive integer";
        this.clearInvalidMsg();
        this.cutoff = FilterDialog.parseDouble(this.cutoffField.getText());
        if (this.cutoff == -1.0) {
            bl = false;
            this.cutoff = 1.0;
            this.addInvalidMsg("Cutoff value", "should be a number");
        }
        this.nConds = FilterDialog.parsePosInt(this.nCondsField.getText());
        if (this.nConds == -1) {
            bl = false;
            this.nConds = 1;
            this.addInvalidMsg("Number of Conditions", string);
        }
        this.nNeighbors = FilterDialog.parsePosInt(this.nNeighborsField.getText());
        if (this.nNeighbors == -1) {
            bl = false;
            this.nNeighbors = 1;
            this.addInvalidMsg("Number of Neighbors", string);
        }
        this.maxDepth = FilterDialog.parsePosInt(this.maxDepthField.getText());
        if (this.maxDepth == -1) {
            bl = false;
            this.maxDepth = 1;
            this.addInvalidMsg("Depth", string);
        }
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        ExpressionFilter expressionFilter = new ExpressionFilter(graph2D, this.expressionData, this.nodeAttributes, this.cutoff, this.cutoffLess.booleanValue(), this.nConds, this.useRatio.booleanValue(), this.nNeighbors, this.maxDepth, this.hideSingletons.booleanValue());
        return expressionFilter;
    }
}

