/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.FilterDialogClient;
import cytoscape.GraphObjAttributes;
import cytoscape.filters.EdgeTypeFilter;
import cytoscape.filters.dialogs.EdgeTypeDialog;
import cytoscape.undo.UndoableGraphHider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import y.base.Edge;
import y.base.EdgeCursor;
import y.view.EdgeRealizer;
import y.view.Graph2D;

public class EdgeTypeDialogIndep
extends JDialog {
    FilterDialogClient client;
    EdgeTypeDialogIndep thisDialog;
    Frame parent;
    Graph2D graph;
    GraphObjAttributes edgeAttributes;
    UndoableGraphHider graphHider;
    String[] interactionTypes;
    EdgeTypeDialog edgeTypeDialog;

    public EdgeTypeDialogIndep(FilterDialogClient filterDialogClient, Frame frame, Graph2D graph2D, GraphObjAttributes graphObjAttributes, UndoableGraphHider undoableGraphHider, String[] stringArray) {
        super(frame, false);
        this.setTitle("Edge Type Filter");
        this.thisDialog = this;
        this.client = filterDialogClient;
        this.parent = frame;
        this.graph = graph2D;
        this.edgeAttributes = graphObjAttributes;
        this.graphHider = undoableGraphHider;
        this.interactionTypes = stringArray;
        this.edgeTypeDialog = new EdgeTypeDialog(graphObjAttributes, stringArray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Select");
        jPanel.add(jButton);
        jButton.addActionListener(new SelectAction());
        JButton jButton2 = new JButton("Invert Selection");
        jPanel.add(jButton2);
        jButton2.addActionListener(new InvertAction());
        JButton jButton3 = new JButton("Hide Selection");
        jPanel.add(jButton3);
        jButton3.addActionListener(new HideAction());
        JButton jButton4 = new JButton("Dismiss");
        jPanel.add(jButton4);
        jButton4.addActionListener(new DismissAction());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        JPanel jPanel3 = this.edgeTypeDialog.getPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "South");
        this.setContentPane(jPanel4);
        this.pack();
        this.setLocation(frame.getLocationOnScreen());
        this.pack();
        this.setVisible(true);
    }

    public class HideAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EdgeTypeDialogIndep.this.graph.firePreEvent();
            EdgeCursor edgeCursor = EdgeTypeDialogIndep.this.graph.selectedEdges();
            while (edgeCursor.ok()) {
                EdgeTypeDialogIndep.this.graphHider.hide(edgeCursor.edge());
                edgeCursor.next();
            }
            EdgeTypeDialogIndep.this.graph.firePostEvent();
            EdgeTypeDialogIndep.this.client.redrawGraph();
        }
    }

    public class InvertAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Edge[] edgeArray = EdgeTypeDialogIndep.this.graph.getEdgeArray();
            for (int i = 0; i < edgeArray.length; ++i) {
                EdgeRealizer edgeRealizer;
                edgeRealizer.setSelected(!(edgeRealizer = EdgeTypeDialogIndep.this.graph.getRealizer(edgeArray[i])).isSelected());
            }
            EdgeTypeDialogIndep.this.client.redrawGraph();
        }
    }

    public class SelectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EdgeTypeDialogIndep.this.edgeTypeDialog.setValid()) {
                JOptionPane.showMessageDialog(EdgeTypeDialogIndep.this.parent, "<html>" + EdgeTypeDialogIndep.this.edgeTypeDialog.getInvalidMsg() + "</html>");
            } else {
                EdgeTypeFilter edgeTypeFilter = (EdgeTypeFilter)EdgeTypeDialogIndep.this.edgeTypeDialog.getFilter(EdgeTypeDialogIndep.this.graph);
                edgeTypeFilter.select();
            }
            EdgeTypeDialogIndep.this.client.redrawGraph();
        }
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeTypeDialogIndep.this.thisDialog.dispose();
        }
    }
}

