/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.EdgeTypeFilter;
import cytoscape.filters.Filter;
import cytoscape.filters.dialogs.FilterDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import y.view.Graph2D;

public class EdgeTypeDialog
extends FilterDialog {
    public static String DESC = "Select edges that are of any of the selected types.";
    GraphObjAttributes edgeAttributes;
    JList typeList;
    String[] interactionTypes;

    public EdgeTypeDialog(GraphObjAttributes graphObjAttributes, String[] stringArray) {
        super(FilterDialog.EDGE_TYPE);
        this.panel.setName("Edge Type");
        this.panel.add(EdgeTypeDialog.createDescPanel(DESC));
        this.edgeAttributes = graphObjAttributes;
        this.interactionTypes = stringArray;
        this.typeList = new JList<String>(this.getTypes());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.typeList, "Center");
        JPanel jPanel2 = FilterDialog.createSubPanel("Interaction Types", new JPanel[]{jPanel});
        this.panel.add(jPanel2);
    }

    public boolean setValid() {
        boolean bl = true;
        this.clearInvalidMsg();
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        Object[] objectArray = this.typeList.getSelectedValues();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        EdgeTypeFilter edgeTypeFilter = new EdgeTypeFilter(graph2D, this.edgeAttributes, stringArray);
        return edgeTypeFilter;
    }

    public String[] getTypes() {
        return this.interactionTypes;
    }
}

