/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.filters.CombinationFilter;
import cytoscape.filters.Filter;
import cytoscape.filters.StableFilter;
import cytoscape.filters.dialogs.BoolPanel;
import cytoscape.filters.dialogs.FilterDialog;
import cytoscape.filters.dialogs.MutableBoolean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import y.view.Graph2D;

public class CombinationDialog
extends FilterDialog {
    public static String DESC = "<html>Select nodes by combinining multiple filters:<br>with <b><code>And</code></b>, select nodes that <b>all</b> of the individual filters would have selected;<br>with <b><code>Or</code></b>,  select nodes that <b>any</b> of the individual filters would have selected.</html>";
    Vector dialogs;
    JList list;
    DefaultListModel listModel;
    MutableBoolean andType = new MutableBoolean(false);
    MutableBoolean stabilize = new MutableBoolean(false);

    public CombinationDialog(Vector vector) {
        super(FilterDialog.COMBINATION);
        Object object;
        Object object2;
        this.panel.setName("Combination");
        this.panel.add(CombinationDialog.createDescPanel(DESC));
        this.dialogs = vector;
        this.listModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (FilterDialog)vector.elementAt(i);
            object = ((FilterDialog)object2).getName();
            this.listModel.addElement(object);
        }
        this.list = new JList(this.listModel);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)jScrollPane, "Center");
        object = FilterDialog.createSubPanel("Filters", new JPanel[]{object2});
        JPanel jPanel = FilterDialog.createSubPanel("Options", new JPanel[]{FilterDialog.createFieldPanel("Combination Type", new BoolPanel(this.andType, "And", "Or").getPanel()), FilterDialog.createFieldPanel("Apply Filter Until Stable Point?", new BoolPanel(this.stabilize, "Yes", "No (Only Once)").getPanel())});
        this.panel.add(jPanel);
        this.panel.add((Component)object);
    }

    public boolean setValid() {
        boolean bl = true;
        this.clearInvalidMsg();
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                FilterDialog filterDialog = (FilterDialog)this.dialogs.elementAt(n);
                if (filterDialog.setValid()) continue;
                bl = false;
                this.addInvalidMsg(filterDialog.getName(), "is not valid");
            }
        } else {
            bl = false;
            this.addInvalidMsg("At least one filter should be included.");
        }
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        int[] nArray = this.list.getSelectedIndices();
        Filter[] filterArray = new Filter[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            FilterDialog filterDialog = (FilterDialog)this.dialogs.elementAt(n);
            filterArray[i] = filterDialog.getFilter(graph2D);
        }
        Filter filter = new CombinationFilter(graph2D, filterArray, this.andType.booleanValue());
        if (this.stabilize.booleanValue()) {
            filter = new StableFilter(graph2D, filter);
        }
        return filter;
    }

    public void update(int n) {
        int[] nArray = this.list.getSelectedIndices();
        FilterDialog filterDialog = (FilterDialog)this.dialogs.elementAt(n);
        this.listModel.insertElementAt(filterDialog.getName(), n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            nArray[i] = nArray[i] + 1;
        }
        this.list.clearSelection();
        this.list.setSelectedIndices(nArray);
    }
}

