/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.filters.Filter;
import cytoscape.filters.ListFilter;
import cytoscape.filters.TopologyCenteredFilter;
import cytoscape.filters.dialogs.FilterDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class CenterDialog
extends FilterDialog {
    public static String DESC = "Select nodes that are within the indicated depth of specific nodes.";
    Frame parent;
    Graph2D graph;
    int nNeighbors;
    JTextField nNeighborsField;
    int maxDepth;
    JTextField maxDepthField;
    JLabel startersLabel;
    Filter startersF;
    boolean startersSelected = false;

    public CenterDialog(Frame frame, Graph2D graph2D) {
        super(FilterDialog.CENTER);
        this.parent = frame;
        this.graph = graph2D;
        this.panel.setName("Nodes Center");
        this.panel.add(CenterDialog.createDescPanel(DESC));
        JButton jButton = new JButton("Get Selected Nodes");
        jButton.addActionListener(new StartersSelectAction());
        this.startersLabel = new JLabel("None selected");
        this.startersLabel.setFont(new Font("SansSerif", 2, 11));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jButton);
        jPanel.add(this.startersLabel);
        JPanel jPanel2 = FilterDialog.createFieldPanel("Starter Nodes", jPanel);
        this.nNeighborsField = new JTextField(4);
        JPanel jPanel3 = FilterDialog.createFieldPanel("Minimum Number of Neighbors", this.nNeighborsField);
        this.maxDepthField = new JTextField(4);
        JPanel jPanel4 = FilterDialog.createFieldPanel("Within Depth", this.maxDepthField);
        JPanel jPanel5 = FilterDialog.createSubPanel("Requirements", new JPanel[]{jPanel2, jPanel3, jPanel4});
        this.panel.add(jPanel5);
        this.createStarters();
    }

    public boolean setValid() {
        boolean bl = true;
        String string = "should be a positive integer";
        this.clearInvalidMsg();
        if (!this.startersSelected) {
            bl = false;
            this.addInvalidMsg("Starter nodes", "sould be selected (at least one node)");
        }
        this.nNeighbors = FilterDialog.parsePosInt(this.nNeighborsField.getText());
        if (this.nNeighbors == -1) {
            bl = false;
            this.nNeighbors = 1;
            this.addInvalidMsg("Number of Neighbors", string);
        }
        this.maxDepth = FilterDialog.parsePosInt(this.maxDepthField.getText());
        if (this.maxDepth == -1) {
            bl = false;
            this.maxDepth = 1;
            this.addInvalidMsg("Depth", string);
        }
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        TopologyCenteredFilter topologyCenteredFilter = new TopologyCenteredFilter(graph2D, this.startersF, this.nNeighbors, this.maxDepth);
        return topologyCenteredFilter;
    }

    private boolean createStarters() {
        NodeList nodeList = new NodeList();
        NodeCursor nodeCursor = this.graph.selectedNodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            nodeList.add((Object)node);
            nodeCursor.next();
        }
        int n = nodeList.size();
        if (n == 0) {
            this.startersSelected = false;
        } else {
            this.startersSelected = true;
            this.startersLabel.setText(n + " selected");
        }
        this.startersF = new ListFilter(this.graph, nodeList);
        return this.startersSelected;
    }

    public class StartersSelectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CenterDialog.this.createStarters()) {
                JOptionPane.showMessageDialog(CenterDialog.this.parent, "Please select the starter nodes from the graph first.");
            }
        }
    }
}

