/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.AttributeFilter;
import cytoscape.filters.Filter;
import cytoscape.filters.dialogs.AttributeSelection;
import cytoscape.filters.dialogs.FilterDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import y.view.Graph2D;

public class AttributeDialog
extends FilterDialog {
    public static String DESC = "Select all nodes whose attribute value matches a particular user-defined value.";
    GraphObjAttributes nodeAttributes;
    AttributeSelection attributeSelection;
    String matchingValue;
    JTextField matchField;

    public AttributeDialog(GraphObjAttributes graphObjAttributes) {
        super(FilterDialog.ATTRIBUTE);
        this.panel.setName("Attribute");
        this.panel.add(AttributeDialog.createDescPanel(DESC));
        this.nodeAttributes = graphObjAttributes;
        this.attributeSelection = new AttributeSelection(graphObjAttributes);
        JPanel jPanel = FilterDialog.createFieldPanel("Attribute for selection:", this.attributeSelection);
        this.matchField = new JTextField(4);
        JPanel jPanel2 = FilterDialog.createFieldPanel("Matching value:", this.matchField);
        this.panel.add(jPanel);
        this.panel.add(jPanel2);
    }

    public boolean setValid() {
        boolean bl = true;
        this.matchingValue = this.matchField.getText();
        if (this.attributeSelection.getAttributeSelected() == null) {
            bl = false;
            this.addInvalidMsg("Attribute", "needs to be selected");
        }
        return bl;
    }

    public Filter getFilter(Graph2D graph2D) {
        this.setValid();
        AttributeFilter attributeFilter = new AttributeFilter(graph2D, this.nodeAttributes, this.attributeSelection.getAttributeSelected(), this.matchingValue);
        return attributeFilter;
    }
}

