/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.filters.Filter;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class TopologyOnePassFilter
extends Filter {
    int nNeighbors;
    int maxDepth;
    Filter neighborF;

    public TopologyOnePassFilter(Graph2D graph2D, Filter filter, int n, int n2, Filter filter2) {
        super(graph2D, filter);
        this.nNeighbors = n;
        this.maxDepth = n2;
        this.neighborF = filter2;
    }

    public TopologyOnePassFilter(Graph2D graph2D, int n, int n2, Filter filter) {
        super(graph2D);
        this.nNeighbors = n;
        this.maxDepth = n2;
        this.neighborF = filter;
    }

    public TopologyOnePassFilter(Graph2D graph2D, int n, int n2) {
        super(graph2D);
        this.nNeighbors = n;
        this.maxDepth = n2;
        this.neighborF = null;
    }

    public NodeList get(NodeList nodeList) {
        NodeList nodeList2 = new NodeList();
        NodeList nodeList3 = new NodeList();
        NodeList nodeList4 = this.getFlaggableF().get(nodeList);
        if (this.neighborF != null) {
            nodeList3 = this.neighborF.get(nodeList);
        }
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (!nodeList.contains((Object)node) && (this.allFlaggable() || nodeList4.contains((Object)node))) {
                int n = 0;
                try {
                    Node node2;
                    NodeList nodeList5 = Filter.bfsDepth(node, this.maxDepth);
                    NodeCursor nodeCursor2 = nodeList5.nodes();
                    while (nodeCursor2.ok() && ((node2 = nodeCursor2.node()) == node || nodeList.contains((Object)node2) || this.neighborF != null && !nodeList3.contains((Object)node2) || ++n < this.nNeighbors)) {
                        nodeCursor2.next();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("!!! ERROR !!! NullPointerException !!!");
                }
                if (n < this.nNeighbors) {
                    nodeList2.add((Object)node);
                }
            }
            nodeCursor.next();
        }
        return nodeList2;
    }
}

