/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.filters.Filter;
import cytoscape.filters.ListFilter;
import cytoscape.filters.NegFilter;
import cytoscape.filters.TopologyOnePassFilter;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class TopologyCenteredFilter
extends Filter {
    Filter startersF;
    int nNeighbors;
    int maxDepth;

    public TopologyCenteredFilter(Graph2D graph2D, Filter filter, int n, int n2) {
        super(graph2D);
        this.nNeighbors = n;
        this.maxDepth = n2;
        this.startersF = filter;
    }

    public NodeList get(NodeList nodeList) {
        NodeList nodeList2;
        NodeList nodeList3 = this.startersF.get(nodeList);
        if (this.nNeighbors == 1 && nodeList3.size() < 5) {
            NodeList nodeList4 = new NodeList();
            Object object = nodeList3.nodes();
            while (object.ok()) {
                Node node = object.node();
                if (!nodeList.contains((Object)node)) {
                    try {
                        NodeList nodeList5 = Filter.bfsDepth(node, this.maxDepth);
                        NodeCursor nodeCursor = nodeList5.nodes();
                        while (nodeCursor.ok()) {
                            Node node2 = nodeCursor.node();
                            if (!nodeList.contains((Object)node2)) {
                                nodeList4.add((Object)node2);
                            }
                            nodeCursor.next();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        System.out.println("!!! ERROR !!! NullPointerException !!!");
                    }
                }
                object.next();
            }
            object = new NegFilter(this.graph, new ListFilter(this.graph, nodeList4));
            nodeList2 = ((Filter)object).get(nodeList);
        } else {
            ListFilter listFilter = new ListFilter(this.graph, nodeList3);
            NegFilter negFilter = new NegFilter(this.graph, listFilter);
            TopologyOnePassFilter topologyOnePassFilter = new TopologyOnePassFilter(this.graph, negFilter, this.nNeighbors, this.maxDepth, listFilter);
            nodeList2 = ((Filter)topologyOnePassFilter).get(nodeList);
        }
        return nodeList2;
    }
}

