/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.Filter;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class NodeTypeFilter
extends Filter {
    GraphObjAttributes nodeAttributes;
    String[] accTypes;

    public NodeTypeFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, Filter filter, String[] stringArray) {
        super(graph2D, filter);
        this.nodeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
    }

    public NodeTypeFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, String[] stringArray) {
        super(graph2D);
        this.nodeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
    }

    public NodeList get(NodeList nodeList) {
        NodeList nodeList2 = new NodeList();
        NodeList nodeList3 = this.getFlaggableF().get(nodeList);
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (!nodeList.contains((Object)node) && (this.allFlaggable() || nodeList3.contains((Object)node))) {
                boolean bl = true;
                String string = this.getType(node);
                for (int i = 0; i < this.accTypes.length; ++i) {
                    boolean bl2 = bl = !string.equals(this.accTypes[i]);
                    if (!bl) break;
                }
                if (bl) {
                    nodeList2.add((Object)node);
                }
            }
            nodeCursor.next();
        }
        return nodeList2;
    }

    public String getType(Node node) {
        String string = this.nodeAttributes.getCanonicalName(node);
        if (string != null) {
            char c = string.charAt(0);
            if (c == 'C') {
                return "compound";
            }
            if (c == 'R') {
                return "reaction";
            }
        }
        return "gene";
    }
}

