/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.Filter;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class InteractionFilter
extends Filter {
    GraphObjAttributes edgeAttributes;
    String[] accTypes;
    String search;

    public InteractionFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, Filter filter, String[] stringArray) {
        super(graph2D, filter);
        this.edgeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
        this.search = "both";
    }

    public InteractionFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, String[] stringArray) {
        super(graph2D);
        this.edgeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
        this.search = "both";
    }

    public InteractionFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, Filter filter, String[] stringArray, String string) {
        super(graph2D, filter);
        this.edgeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
        this.search = string;
    }

    public InteractionFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, String[] stringArray, String string) {
        super(graph2D);
        this.edgeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
        this.search = string;
    }

    public NodeList get(NodeList nodeList) {
        NodeList nodeList2 = new NodeList();
        NodeList nodeList3 = this.getFlaggableF().get(nodeList);
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (!nodeList.contains((Object)node) && (this.allFlaggable() || nodeList3.contains((Object)node))) {
                boolean bl = true;
                EdgeCursor edgeCursor = InteractionFilter.getCursor(node, this.search);
                block1: while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    String string = this.getType(edge);
                    for (int i = 0; i < this.accTypes.length; ++i) {
                        boolean bl2 = bl = !string.equals(this.accTypes[i]);
                        if (!bl) break block1;
                    }
                    edgeCursor.next();
                }
                if (bl) {
                    nodeList2.add((Object)node);
                }
            }
            nodeCursor.next();
        }
        return nodeList2;
    }

    public String getType(Edge edge) {
        String string = (String)this.edgeAttributes.getValue("interaction", this.edgeAttributes.getCanonicalName(edge));
        return string;
    }

    public static EdgeCursor getCursor(Node node, String string) {
        EdgeCursor edgeCursor = string.equals("source") ? node.outEdges() : (string.equals("target") ? node.inEdges() : node.edges());
        return edgeCursor;
    }
}

