/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.filters.NegFilter;
import cytoscape.filters.TrueFilter;
import cytoscape.undo.UndoableGraphHider;
import java.util.Hashtable;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public abstract class Filter {
    private Filter flaggableF;
    protected Graph2D graph;

    public Filter(Graph2D graph2D) {
        this.flaggableF = null;
        this.graph = graph2D;
    }

    public Filter(Graph2D graph2D, Filter filter) {
        this.flaggableF = filter;
        this.graph = graph2D;
    }

    protected boolean allFlaggable() {
        return this.flaggableF == null;
    }

    protected Filter getFlaggableF() {
        if (!this.allFlaggable()) {
            return this.flaggableF;
        }
        return new TrueFilter(this.graph);
    }

    protected abstract NodeList get(NodeList var1);

    public NodeList get() {
        return this.get(new NodeList());
    }

    protected int hide(UndoableGraphHider undoableGraphHider, NodeList nodeList) {
        NodeList nodeList2 = this.get(nodeList);
        int n = 0;
        NodeCursor nodeCursor = nodeList2.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            undoableGraphHider.hide(node);
            ++n;
            nodeCursor.next();
        }
        System.out.println(n + " nodes hidden.");
        return n;
    }

    protected int select(NodeList nodeList) {
        NegFilter negFilter = new NegFilter(this.graph, this);
        NodeList nodeList2 = ((Filter)negFilter).get(nodeList);
        int n = 0;
        NodeCursor nodeCursor = nodeList2.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (!this.graph.isSelected(node)) {
                this.graph.setSelected(node, true);
                ++n;
            }
            nodeCursor.next();
        }
        System.out.println(n + " nodes selected.");
        return n;
    }

    public int hide(UndoableGraphHider undoableGraphHider) {
        return this.hide(undoableGraphHider, new NodeList());
    }

    public int select() {
        return this.select(new NodeList());
    }

    public static NodeList bfsDepth(Node node, int n) {
        Hashtable<Node, Integer> hashtable = new Hashtable<Node, Integer>();
        NodeList nodeList = new NodeList();
        nodeList.add((Object)node);
        hashtable.put(node, new Integer(0));
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node2 = (Node)nodeList.elementAt(i);
            EdgeCursor edgeCursor = node2.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                Node node3 = edge.opposite(node2);
                Integer n2 = (Integer)hashtable.get(node2);
                Integer n3 = (Integer)hashtable.get(node3);
                if (n3 == null && n2 < n) {
                    nodeList.add((Object)node3);
                    hashtable.put(node3, new Integer(n2 + 1));
                }
                edgeCursor.next();
            }
        }
        return nodeList;
    }
}

