/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import cytoscape.filters.Filter;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class ExpressionOnlyFilter
extends Filter {
    double cutoff;
    boolean cutoffSmallerThan;
    int nConds;
    ExpressionData expressionData;
    GraphObjAttributes nodeAttributes;
    boolean useRatio;

    public ExpressionOnlyFilter(Graph2D graph2D, ExpressionData expressionData, GraphObjAttributes graphObjAttributes, double d, boolean bl, int n, boolean bl2) {
        super(graph2D);
        this.expressionData = expressionData;
        this.nodeAttributes = graphObjAttributes;
        this.cutoff = d;
        this.cutoffSmallerThan = bl;
        this.nConds = n;
        this.useRatio = bl2;
    }

    public NodeList get(NodeList nodeList) {
        NodeList nodeList2 = new NodeList();
        String[] stringArray = this.expressionData.getConditionNames();
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (this.nConds > 0 && !nodeList.contains((Object)node)) {
                String string = this.nodeAttributes.getCanonicalName(node);
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        String string2 = stringArray[i];
                        mRNAMeasurement mRNAMeasurement2 = this.expressionData.getMeasurement(string, string2);
                        double d = this.useRatio ? mRNAMeasurement2.getRatio() : mRNAMeasurement2.getSignificance();
                        if (!(!this.cutoffSmallerThan && d >= this.cutoff) && (!this.cutoffSmallerThan || !(d <= this.cutoff)) || ++n < this.nConds) continue;
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (n < this.nConds) {
                    nodeList2.add((Object)node);
                }
            }
            nodeCursor.next();
        }
        return nodeList2;
    }
}

