/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.Filter;
import cytoscape.undo.UndoableGraphHider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class EdgeTypeFilter
extends Filter {
    protected Graph2D graph;
    GraphObjAttributes edgeAttributes;
    String[] accTypes;

    public EdgeTypeFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, String[] stringArray) {
        super(graph2D);
        this.graph = graph2D;
        this.edgeAttributes = graphObjAttributes;
        this.accTypes = stringArray;
    }

    public String getType(Edge edge) {
        String string = (String)this.edgeAttributes.getValue("interaction", this.edgeAttributes.getCanonicalName(edge));
        return string;
    }

    public boolean accType(String string) {
        boolean bl = false;
        for (int i = 0; i < this.accTypes.length && !(bl = string.equals(this.accTypes[i])); ++i) {
        }
        return bl;
    }

    public int select() {
        int n = 0;
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (!this.graph.isSelected(edge) && this.accType(this.getType(edge))) {
                this.graph.setSelected(edge, true);
                ++n;
            }
            edgeCursor.next();
        }
        System.out.println(n + " edges selected.");
        return n;
    }

    public NodeList get() {
        return new NodeList();
    }

    public NodeList get(NodeList nodeList) {
        return new NodeList();
    }

    public int hide(UndoableGraphHider undoableGraphHider) {
        return 0;
    }
}

