/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.filters;

import cytoscape.GraphObjAttributes;
import cytoscape.filters.Filter;
import java.util.List;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.Graph2D;

public class AttributeFilter
extends Filter {
    String matchingValue;
    double matchingDouble;
    boolean doubleFlag = false;
    int matchingInt;
    boolean intFlag = false;
    String attributeSelected;
    GraphObjAttributes nodeAttributes;

    public AttributeFilter(Graph2D graph2D, GraphObjAttributes graphObjAttributes, String string, String string2) {
        super(graph2D);
        this.nodeAttributes = graphObjAttributes;
        this.matchingValue = string2;
        this.attributeSelected = string;
        this.prepClassHandling();
    }

    private void prepClassHandling() {
        if (this.attributeSelected == null) {
            return;
        }
        if (this.nodeAttributes.getClass(this.attributeSelected).equals(Double.class)) {
            try {
                this.matchingDouble = new Double(this.matchingValue);
                this.doubleFlag = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.nodeAttributes.getClass(this.attributeSelected).equals(Integer.class)) {
            try {
                this.matchingInt = new Integer(this.matchingValue);
                this.intFlag = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public NodeList get(NodeList nodeList) {
        NodeList nodeList2 = new NodeList();
        NodeCursor nodeCursor = this.graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (this.attributeSelected == null) {
                nodeList2.add((Object)node);
            } else {
                Object object;
                String string = this.nodeAttributes.getCanonicalName(node);
                Object object2 = this.nodeAttributes.get(this.attributeSelected, string);
                if (object2 instanceof List) {
                    object = ((List)object2).iterator();
                    boolean bl = false;
                    while (object.hasNext()) {
                        Object e = object.next();
                        if (this.doubleFlag && e != null) {
                            if ((Double)e != this.matchingDouble) continue;
                            bl = true;
                            continue;
                        }
                        if (this.intFlag && e != null) {
                            if ((Integer)e != this.matchingInt) continue;
                            bl = true;
                            continue;
                        }
                        if (e instanceof String) {
                            String string2 = (String)e;
                            String string3 = this.matchingValue;
                            if (!string2.equals(string3)) continue;
                            bl = true;
                            continue;
                        }
                        if (e == null) continue;
                        System.out.println(e.getClass().toString());
                    }
                    if (!bl) {
                        nodeList2.add((Object)node);
                    }
                } else if (this.doubleFlag && object2 != null) {
                    if ((Double)object2 != this.matchingDouble) {
                        nodeList2.add((Object)node);
                    }
                } else if (this.intFlag && object2 != null) {
                    if ((Integer)object2 != this.matchingInt) {
                        nodeList2.add((Object)node);
                    }
                } else if (object2 instanceof String) {
                    object = (String)object2;
                    String string4 = this.matchingValue;
                    if (!((String)object).equals(string4)) {
                        nodeList2.add((Object)node);
                    }
                } else {
                    if (object2 != null) {
                        System.out.println(object2.getClass().toString());
                    }
                    nodeList2.add((Object)node);
                }
            }
            nodeCursor.next();
        }
        return nodeList2;
    }
}

