/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.dialogs.EdgeTextPanel;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.IconPopupButton;
import cytoscape.dialogs.JointIntegerEntry;
import cytoscape.dialogs.LabelTextPanel;
import cytoscape.dialogs.MiscDialog;
import cytoscape.dialogs.MiscGB;
import cytoscape.util.MutableBool;
import cytoscape.util.MutableColor;
import cytoscape.util.MutableString;
import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.DiscreteMapper;
import cytoscape.vizmap.VizMapperCategories;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import y.view.Arrow;
import y.view.LineType;

public class VisualPropertiesDialog
extends JDialog {
    static Map backupMap = null;
    static String backupKey = null;
    static boolean useMapping = true;
    IconPopupButton shapeDefault;
    IconPopupButton lineTypeDefault;
    IconPopupButton arrowDefault;
    JointIntegerEntry sizeDefaults;
    AttributeMapper aMapper;
    Frame parentFrame;
    MutableColor nColor;
    MutableColor bColor;
    MutableColor bgColor;
    MutableColor eColor;
    MutableString localNodeLabelKey;
    MutableString parentNodeLabelKey;
    MutableString localEdgeKey;
    MutableBool applied;
    EdgeTextPanel edgeTextPanel;

    public VisualPropertiesDialog(Frame frame, String string, AttributeMapper attributeMapper, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, MutableString mutableString, MutableBool mutableBool) {
        super(frame, true);
        this.setTitle(string);
        this.parentFrame = frame;
        this.aMapper = attributeMapper;
        this.nColor = new MutableColor(this.getBasicColor(VizMapperCategories.NODE_FILL_COLOR));
        this.bColor = new MutableColor(this.getBasicColor(VizMapperCategories.NODE_BORDER_COLOR));
        this.bgColor = new MutableColor(this.getBasicColor(VizMapperCategories.BG_COLOR));
        this.eColor = new MutableColor(this.getBasicColor(VizMapperCategories.EDGE_COLOR));
        this.localNodeLabelKey = new MutableString(mutableString.getString());
        this.parentNodeLabelKey = mutableString;
        this.applied = mutableBool;
        GridBagGroup gridBagGroup = new GridBagGroup();
        JPanel jPanel = gridBagGroup.panel;
        MiscGB.pad(gridBagGroup.constraints, 5, 5);
        GridBagGroup gridBagGroup2 = new GridBagGroup("Defaults");
        MiscGB.pad(gridBagGroup2.constraints, 5, 5);
        int n = 0;
        int n2 = 0;
        JLabel jLabel = MiscGB.createColorLabel(this.nColor.getColor());
        JButton jButton = MiscGB.buttonAndColor(this, this.nColor, jLabel, "Node Color");
        MiscGB.insert(gridBagGroup2, jButton, 0, n2, 1, 1, 2);
        MiscGB.insert(gridBagGroup2, (Component)jLabel, 1, n2);
        JLabel jLabel2 = MiscGB.createColorLabel(this.bColor.getColor());
        JButton jButton2 = MiscGB.buttonAndColor(this, this.bColor, jLabel2, "Node Border Color");
        MiscGB.insert(gridBagGroup2, (Component)jLabel2, 1, ++n2);
        MiscGB.insert(gridBagGroup2, jButton2, 0, n2, 1, 1, 2);
        JLabel jLabel3 = MiscGB.createColorLabel(this.bgColor.getColor());
        JButton jButton3 = MiscGB.buttonAndColor(this, this.bgColor, jLabel3, "Background Color");
        MiscGB.insert(gridBagGroup2, (Component)jLabel3, 1, ++n2);
        MiscGB.insert(gridBagGroup2, jButton3, 0, n2, 1, 1, 2);
        JLabel jLabel4 = MiscGB.createColorLabel(this.eColor.getColor());
        JButton jButton4 = MiscGB.buttonAndColor(this, this.eColor, jLabel4, "Edge Color");
        MiscGB.insert(gridBagGroup2, (Component)jLabel4, 1, ++n2);
        MiscGB.insert(gridBagGroup2, jButton4, 0, n2, 1, 1, 2);
        this.sizeDefaults = new JointIntegerEntry("Node", "Height", "Width", (int)((Double)this.aMapper.getDefaultValue(VizMapperCategories.NODE_HEIGHT)).doubleValue(), (int)((Double)this.aMapper.getDefaultValue(VizMapperCategories.NODE_WIDTH)).doubleValue(), 500, 500);
        MiscGB.insert(gridBagGroup2, (Component)this.sizeDefaults.getConstraintLabel(), 0, ++n2);
        MiscGB.insert(gridBagGroup2, (Component)this.sizeDefaults.getConstraintBox(), 1, n2);
        MiscGB.insert(gridBagGroup2, (Component)this.sizeDefaults.getLabel("Height"), 0, ++n2);
        MiscGB.insert(gridBagGroup2, (Component)this.sizeDefaults.getField("Height"), 1, n2);
        MiscGB.insert(gridBagGroup2, (Component)this.sizeDefaults.getLabel("Width"), 0, ++n2);
        MiscGB.insert(gridBagGroup2, (Component)this.sizeDefaults.getField("Width"), 1, n2);
        this.initializeShapeDefault();
        MiscGB.insert(gridBagGroup2, this.shapeDefault.getButton(), 0, ++n2, 1, 1, 2);
        MiscGB.insert(gridBagGroup2, (Component)this.shapeDefault.getLabel(), 1, n2);
        this.initializeLineTypeDefault();
        MiscGB.insert(gridBagGroup2, this.lineTypeDefault.getButton(), 0, ++n2, 1, 1, 2);
        MiscGB.insert(gridBagGroup2, (Component)this.lineTypeDefault.getLabel(), 1, n2);
        this.initializeArrowDefault();
        MiscGB.insert(gridBagGroup2, this.arrowDefault.getButton(), 0, ++n2, 1, 1, 2);
        MiscGB.insert(gridBagGroup2, (Component)this.arrowDefault.getLabel(), 1, n2);
        ++n2;
        MiscGB.insert(gridBagGroup, gridBagGroup2.panel, 0, n, 2, 1, 2);
        GridBagGroup gridBagGroup3 = new GridBagGroup("Node Label Mapping");
        LabelTextPanel labelTextPanel = new LabelTextPanel(graphObjAttributes, this.localNodeLabelKey);
        MiscGB.insert(gridBagGroup3, (Component)labelTextPanel, 0, 0);
        MiscGB.insert(gridBagGroup, gridBagGroup3.panel, 0, ++n, 2, 1, 2);
        ++n;
        GridBagGroup gridBagGroup4 = new GridBagGroup("Edge Color Mapping");
        if (this.localEdgeKey == null) {
            this.localEdgeKey = new MutableString("temp");
        }
        this.edgeTextPanel = new EdgeTextPanel(graphObjAttributes2, this.aMapper, frame, this.localEdgeKey, backupMap, backupKey, useMapping);
        MiscGB.insert(gridBagGroup4, (Component)this.edgeTextPanel, 0, 0);
        MiscGB.insert(gridBagGroup, gridBagGroup4.panel, 0, n, 2, 1, 2);
        JButton jButton5 = new JButton("Apply");
        jButton5.addActionListener(new ApplyAction());
        MiscGB.insert(gridBagGroup, (Component)jButton5, 0, ++n);
        JButton jButton6 = new JButton("Cancel");
        jButton6.addActionListener(new CancelAction());
        MiscGB.insert(gridBagGroup, (Component)jButton6, 1, n);
        ++n;
        this.setContentPane(jPanel);
    }

    private Color getBasicColor(Integer n) {
        Color color;
        try {
            color = (Color)this.aMapper.getDefaultValue(n);
        }
        catch (NullPointerException nullPointerException) {
            color = new Color(255, 255, 255);
        }
        if (color != null) {
            return color;
        }
        return new Color(255, 255, 255);
    }

    private Color getDMColor(Integer n, String string) {
        DiscreteMapper discreteMapper = (DiscreteMapper)this.aMapper.getValueMapper(n);
        Map map = discreteMapper.getValueMap();
        Color color = (Color)map.get(string);
        if (color != null) {
            return color;
        }
        return new Color(255, 255, 255);
    }

    private void initializeArrowDefault() {
        int n = (int)((Double)this.aMapper.getDefaultValue(VizMapperCategories.NODE_HEIGHT)).doubleValue();
        Object object = this.aMapper.getDefaultValue(VizMapperCategories.EDGE_TARGET_DECORATION);
        HashMap hashMap = MiscDialog.getArrowToStringHashMap(n);
        HashMap hashMap2 = MiscDialog.getStringToArrowHashMap(n);
        MiscDialog miscDialog = new MiscDialog();
        ImageIcon[] imageIconArray = miscDialog.getArrowIcons();
        this.arrowDefault = new IconPopupButton("Arrow", "Arrow", hashMap, hashMap2, imageIconArray, object, this);
    }

    private void initializeShapeDefault() {
        Object object = this.aMapper.getDefaultValue(VizMapperCategories.NODE_SHAPE);
        HashMap hashMap = MiscDialog.getShapeByteToStringHashMap();
        HashMap hashMap2 = MiscDialog.getStringToShapeByteHashMap();
        MiscDialog miscDialog = new MiscDialog();
        ImageIcon[] imageIconArray = miscDialog.getShapeIcons();
        this.shapeDefault = new IconPopupButton("Node Shape", "Node Shape", hashMap, hashMap2, imageIconArray, object, this);
    }

    private void initializeLineTypeDefault() {
        Object object = this.aMapper.getDefaultValue(VizMapperCategories.EDGE_LINETYPE);
        HashMap hashMap = MiscDialog.getLineTypeToStringHashMap();
        HashMap hashMap2 = MiscDialog.getStringToLineTypeHashMap();
        MiscDialog miscDialog = new MiscDialog();
        ImageIcon[] imageIconArray = miscDialog.getLineTypeIcons();
        this.lineTypeDefault = new IconPopupButton("Line Type", "Line Type", hashMap, hashMap2, imageIconArray, object, this);
    }

    public class CancelAction
    extends AbstractAction {
        CancelAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisualPropertiesDialog.this.applied.setBool(false);
            VisualPropertiesDialog.this.dispose();
        }
    }

    public class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Map map;
            Arrow arrow;
            Serializable serializable;
            Number number;
            Integer n;
            LineType lineType;
            Byte by;
            Color color;
            Color color2;
            Object object;
            Color color3 = VisualPropertiesDialog.this.nColor.getColor();
            if (color3 != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.NODE_FILL_COLOR, color3);
            }
            if ((color2 = VisualPropertiesDialog.this.bgColor.getColor()) != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.BG_COLOR, color2);
            }
            if ((color = VisualPropertiesDialog.this.eColor.getColor()) != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.EDGE_COLOR, color);
            }
            if ((by = (Byte)VisualPropertiesDialog.this.shapeDefault.getIconObject()) != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.NODE_SHAPE, by);
            }
            if ((lineType = (LineType)VisualPropertiesDialog.this.lineTypeDefault.getIconObject()) != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.EDGE_LINETYPE, lineType);
            }
            if ((n = VisualPropertiesDialog.this.sizeDefaults.getInteger("Height")) != null) {
                number = new Double(n.intValue());
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.NODE_HEIGHT, number);
            }
            if ((number = VisualPropertiesDialog.this.sizeDefaults.getInteger("Width")) != null) {
                serializable = new Double(((Integer)number).intValue());
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.NODE_WIDTH, serializable);
            }
            if ((serializable = VisualPropertiesDialog.this.bColor.getColor()) != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.NODE_BORDER_COLOR, serializable);
            }
            if ((arrow = (Arrow)VisualPropertiesDialog.this.arrowDefault.getIconObject()) != null) {
                object = VisualPropertiesDialog.this.aMapper.setDefaultValue(VizMapperCategories.EDGE_TARGET_DECORATION, arrow);
            }
            if ((map = VisualPropertiesDialog.this.edgeTextPanel.getMap()) != null) {
                backupMap = map;
                backupKey = VisualPropertiesDialog.this.localEdgeKey.getString();
            }
            if (VisualPropertiesDialog.this.edgeTextPanel.didStateChange()) {
                useMapping = VisualPropertiesDialog.this.edgeTextPanel.useMappingGenerally();
                if (useMapping && VisualPropertiesDialog.this.edgeTextPanel.getWhetherToUseTheMap()) {
                    if (map != null) {
                        VisualPropertiesDialog.this.aMapper.setAttributeMapEntry(VizMapperCategories.EDGE_COLOR, VisualPropertiesDialog.this.localEdgeKey.getString(), new DiscreteMapper(map));
                    }
                    VisualPropertiesDialog.this.edgeTextPanel.updateMapperScalableArrows();
                } else if (useMapping) {
                    if (backupMap != null) {
                        VisualPropertiesDialog.this.aMapper.setAttributeMapEntry(VizMapperCategories.EDGE_COLOR, backupKey, new DiscreteMapper(backupMap));
                    }
                } else {
                    VisualPropertiesDialog.this.aMapper.removeAttributeMapEntry(VizMapperCategories.EDGE_COLOR);
                }
            }
            VisualPropertiesDialog.this.parentNodeLabelKey.setString(VisualPropertiesDialog.this.localNodeLabelKey.getString());
            VisualPropertiesDialog.this.applied.setBool(true);
            VisualPropertiesDialog.this.dispose();
        }
    }
}

