/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class ShrinkExpandGraph
extends AbstractAction {
    protected CytoscapeWindow cytoscapeWindow;
    protected double m;

    ShrinkExpandGraph(CytoscapeWindow cytoscapeWindow, String string, double d) {
        super(string);
        this.cytoscapeWindow = cytoscapeWindow;
        this.m = d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NodeRealizer nodeRealizer;
        Node node;
        int n;
        Graph2D graph2D = this.cytoscapeWindow.getGraph();
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getEdgeAttributes();
        Node[] nodeArray = graph2D.getNodeArray();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < nodeArray.length; ++n) {
            node = nodeArray[n];
            nodeRealizer = graph2D.getRealizer(node);
            double d5 = nodeRealizer.getCenterX();
            double d6 = nodeRealizer.getCenterY();
            d += d5;
            d2 += d6;
        }
        d3 = d / (double)(nodeArray.length + 1);
        d4 = d2 / (double)(nodeArray.length + 1);
        for (n = 0; n < nodeArray.length; ++n) {
            node = nodeArray[n];
            nodeRealizer = graph2D.getRealizer(node);
            nodeRealizer.setCenterX(this.m * (nodeRealizer.getCenterX() - d3) + d3);
            nodeRealizer.setCenterY(this.m * (nodeRealizer.getCenterY() - d4) + d4);
        }
        EdgeCursor edgeCursor = graph2D.edges();
        edgeCursor.toFirst();
        for (int i = 0; i < edgeCursor.size(); ++i) {
            nodeRealizer = edgeCursor.edge();
            EdgeRealizer edgeRealizer = graph2D.getRealizer((Edge)nodeRealizer);
            edgeRealizer.clearBends();
            edgeCursor.cyclicNext();
        }
        this.cytoscapeWindow.redrawGraph();
    }
}

