/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CytoscapeWindow;
import cytoscape.layout.RotateLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import y.layout.LayoutGraph;
import y.view.Graph2D;

public class RotateSelectionDialog
extends JDialog {
    JDialog thisDialog = this;

    public RotateSelectionDialog(JFrame jFrame, CytoscapeWindow cytoscapeWindow, Graph2D graph2D) {
        super(jFrame, "Rotate Selected Nodes", true);
        JLabel jLabel = new JLabel("Angle", 0);
        jLabel.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Dismiss");
        jPanel.add(jButton);
        jButton.addActionListener(new DismissAction());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JSlider jSlider = new JSlider(0, -180, 180, 0);
        jPanel2.add(jSlider);
        jSlider.setMajorTickSpacing(90);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(new RotateSelectionAngleListener(cytoscapeWindow, graph2D));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "South");
        this.setContentPane(jPanel3);
        this.pack();
        this.setLocation(jFrame.getLocationOnScreen());
        this.pack();
        this.setVisible(true);
    }

    protected class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RotateSelectionDialog.this.thisDialog.dispose();
        }
    }

    protected class RotateSelectionAngleListener
    implements ChangeListener {
        CytoscapeWindow window;
        Graph2D graph;
        double last = 0.0;

        RotateSelectionAngleListener(CytoscapeWindow cytoscapeWindow, Graph2D graph2D) {
            this.window = cytoscapeWindow;
            this.graph = graph2D;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            double d = (double)jSlider.getValue() / 180.0 * Math.PI;
            RotateLayoutHelper.rotate((LayoutGraph)this.graph, this.graph.selectedNodes(), d - this.last);
            this.last = d;
            this.window.redrawGraph();
        }
    }
}

