/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewSlider
extends JPanel {
    private int minimum;
    private int maximum;
    private int current;
    private int sigFigs;
    private JLabel myTitle;
    private JLabel myMin;
    private JLabel myMax;
    private MJTextField myTextbox;
    private String title;
    private MJSlider mySlider;
    String attributeName;

    public NewSlider() {
        this.sigFigs = 0;
        this.minimum = this.returnInt(0.0);
        this.maximum = this.returnInt(100.0);
        this.current = this.returnInt(50.0);
        this.title = new String(" ");
        this.attributeName = "";
        this.setup();
    }

    public NewSlider(String string, double d, double d2, double d3) {
        this.sigFigs = 0;
        this.title = new String(string);
        this.minimum = this.returnInt(d);
        this.maximum = this.returnInt(d2);
        this.current = this.returnInt(d3);
        this.setup();
    }

    public NewSlider(String string, double d, double d2, double d3, int n) {
        this.sigFigs = n;
        this.title = new String(string);
        this.minimum = this.returnInt(d);
        this.maximum = this.returnInt(d2);
        this.current = this.returnInt(d3);
        this.setup();
    }

    public NewSlider(String string, String string2, double d, double d2, double d3) {
        this.sigFigs = 0;
        this.title = new String(string2);
        this.minimum = this.returnInt(d);
        this.maximum = this.returnInt(d2);
        this.current = this.returnInt(d3);
        this.attributeName = string;
        this.setup();
    }

    public NewSlider(String string, String string2, double d, double d2, double d3, int n) {
        this.sigFigs = n;
        this.title = new String(string2);
        this.minimum = this.returnInt(d);
        this.maximum = this.returnInt(d2);
        this.current = this.returnInt(d3);
        this.attributeName = string;
        this.setup();
    }

    public void setup() {
        if (this.current < this.minimum) {
            this.current = this.minimum;
        }
        if (this.current > this.maximum) {
            this.current = this.maximum;
        }
        this.mySlider = new MJSlider((double)this.minimum, (double)this.maximum, (double)this.current);
        this.myTextbox = this.sigFigs == 0 ? new MJTextField((int)this.returnDouble(this.current).doubleValue(), 6) : new MJTextField(this.returnDouble(this.current), 6);
        if (this.sigFigs == 0) {
            this.myMin = new JLabel(String.valueOf((int)this.returnDouble(this.minimum).doubleValue()), 2);
            this.myMax = new JLabel(String.valueOf((int)this.returnDouble(this.maximum).doubleValue()), 4);
        } else {
            this.myMin = new JLabel(String.valueOf(this.returnDouble(this.minimum)), 2);
            this.myMax = new JLabel(String.valueOf(this.returnDouble(this.maximum)), 4);
        }
        this.myTitle = new JLabel(this.title);
        JLabel jLabel = new JLabel(" ");
        JPanel jPanel = new JPanel();
        jPanel.add((Component)this.myTitle, "Center");
        jPanel.add(this.myTextbox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2));
        jPanel2.add(this.myMin);
        jPanel2.add(this.myMax);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.add(jPanel);
        jPanel3.add(this.mySlider);
        jPanel3.add(jPanel2);
        this.add(jPanel3);
        Dimension dimension = this.getPreferredSize();
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
    }

    public double getDoubleValue() {
        return this.returnDouble(this.current);
    }

    public int getIntegerValue() {
        return (int)this.returnDouble(this.current).doubleValue();
    }

    private int returnInt(double d) {
        return (int)(d * Math.pow(10.0, this.sigFigs));
    }

    private Double returnDouble(int n) {
        Double d = new Double((double)n / Math.pow(10.0, this.sigFigs));
        return d;
    }

    public class MJSlider
    extends JSlider
    implements ChangeListener {
        String test;

        MJSlider(double d, double d2, double d3) {
            super((int)d, (int)d2, (int)d3);
            this.setMajorTickSpacing((NewSlider.this.maximum - NewSlider.this.minimum) / 4);
            this.setPaintTicks(true);
            this.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            NewSlider.this.current = jSlider.getValue();
            String string = NewSlider.this.myTitle.getText();
            if (NewSlider.this.sigFigs == 0) {
                int n = NewSlider.this.returnInt(jSlider.getValue());
                NewSlider.this.myTextbox.setText(String.valueOf(n));
            } else {
                Double d = NewSlider.this.returnDouble(jSlider.getValue());
                NewSlider.this.myTextbox.setText(String.valueOf(d));
            }
        }
    }

    public class MJTextField
    extends JTextField
    implements ActionListener {
        MJTextField(double d, int n) {
            super(String.valueOf(d), n);
            this.addActionListener(this);
        }

        MJTextField(int n, int n2) {
            super(String.valueOf(n), n2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getText();
            Double d = new Double(string);
            int n = NewSlider.this.returnInt(d);
            if (NewSlider.this.minimum <= n && n <= NewSlider.this.maximum) {
                NewSlider.this.mySlider.setValue(n);
            } else {
                this.setText(String.valueOf(NewSlider.this.returnDouble(NewSlider.this.mySlider.getValue())));
            }
        }
    }
}

