/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IntegerEntryField
extends JPanel {
    JTextField sizeField;
    JLabel sizeLabel;
    JFrame mainFrame;
    JPanel mainPanel;

    public IntegerEntryField(String string, int n, int n2) {
        super(new GridLayout(1, 2, 10, 10));
        this.sizeLabel = new JLabel(string);
        this.sizeField = new JTextField(Integer.toString(n));
        this.sizeField.addFocusListener(new PositiveIntegerListener(n, n2));
        this.add(this.sizeLabel);
        this.add(this.sizeField);
    }

    public Integer getInteger() {
        return new Integer(this.sizeField.getText());
    }

    public void setInteger(Integer n) {
        this.sizeField.setText(n.toString());
    }

    public int getInt() {
        return Integer.parseInt(this.sizeField.getText());
    }

    public void setInt(int n) {
        this.sizeField.setText(Integer.toString(n));
    }

    public JTextField getField() {
        return this.sizeField;
    }

    public JLabel getLabel() {
        return this.sizeLabel;
    }

    public class PositiveIntegerListener
    implements FocusListener {
        private int digits;
        private int maxval;
        private int defaultVal;
        private String maxvalString;
        private String defaultString;

        public PositiveIntegerListener(int n, int n2) {
            this.maxval = n2;
            this.defaultVal = n;
            this.maxvalString = Integer.toString(n2);
            this.defaultString = Integer.toString(n);
            this.digits = this.maxvalString.length();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.validate((JTextField)focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
            this.validate((JTextField)focusEvent.getSource());
        }

        private void validate(JTextField jTextField) {
            block8: {
                String string = jTextField.getText();
                if ((string = string.replaceAll("[^0-9]", "")).length() > 0) {
                    if (string.length() > this.digits) {
                        jTextField.setText(this.maxvalString);
                    } else {
                        try {
                            int n = Integer.parseInt(string);
                            if (n <= 0) {
                                jTextField.setText(this.defaultString);
                                break block8;
                            }
                            if (n > this.maxval) {
                                jTextField.setText(this.maxvalString);
                                break block8;
                            }
                            jTextField.setText(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Not an integer: " + string);
                            jTextField.setText(this.defaultString);
                        }
                    }
                } else {
                    jTextField.setText(this.defaultString);
                }
            }
        }
    }
}

