/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class IconPopupButton
extends JPanel
implements ActionListener {
    String title;
    String objectName;
    String currentIconName;
    Object currentIcon;
    JButton iconButton;
    JLabel iconSelectionForPanel;
    JFrame mainFrame;
    JDialog mainDialog;
    JPanel mainPanel;
    HashMap iconObjectToString;
    HashMap stringToIconObject;
    JList iconList;
    JDialog parentDialog;
    boolean alreadyConstructed;

    public IconPopupButton(String string, String string2, HashMap hashMap, HashMap hashMap2, ImageIcon[] imageIconArray, Object object, JDialog jDialog) {
        this.title = string;
        if (imageIconArray.length == 0) {
            this.setupErrorWindow();
            return;
        }
        if (imageIconArray[0] == null || imageIconArray[0].getIconWidth() < 0) {
            System.out.println(imageIconArray[0].getImage().getWidth(jDialog));
            this.setupErrorWindow();
            return;
        }
        this.alreadyConstructed = false;
        this.objectName = string2;
        this.iconObjectToString = hashMap;
        this.stringToIconObject = hashMap2;
        this.parentDialog = jDialog;
        this.iconList = new JList<ImageIcon>(imageIconArray);
        if (object != null) {
            this.setIconObject(object);
        } else {
            System.out.println("starticon null " + string);
            ImageIcon imageIcon = (ImageIcon)this.iconList.getModel().getElementAt(0);
            this.setIconName(imageIcon.getDescription());
        }
        this.setupWindow();
    }

    private void setupWindow() {
        ListModel listModel = this.iconList.getModel();
        ImageIcon imageIcon = (ImageIcon)listModel.getElementAt(0);
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            ImageIcon imageIcon2 = (ImageIcon)listModel.getElementAt(i);
            if (this.currentIconName != imageIcon2.getDescription()) continue;
            imageIcon = imageIcon2;
            this.iconList.setSelectedValue(imageIcon, true);
        }
        this.iconButton = new JButton(this.title);
        this.iconButton.addActionListener(this);
        this.mainPanel = new JPanel(new GridLayout(0, 1));
        this.iconSelectionForPanel = new JLabel(imageIcon);
        this.add(this.iconButton);
        this.add(this.iconSelectionForPanel);
    }

    private void setupErrorWindow() {
        this.iconButton = new JButton(this.title + ": CYTOSCAPE_HOME error");
        this.iconSelectionForPanel = new JLabel(" X ");
        JLabel jLabel = new JLabel("ERROR: No CYTOSCAPE_HOME specified on java command line.");
        this.add(jLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.alreadyConstructed) {
            this.mainDialog = new JDialog((Dialog)this.parentDialog, this.title);
            final JButton jButton = new JButton("Apply");
            JButton jButton2 = new JButton("Dismiss");
            jButton.addActionListener(new ApplyIconAction());
            jButton2.addActionListener(new DismissIconAction());
            this.iconList.setLayoutOrientation(2);
            this.iconList.setVisibleRowCount(1);
            this.iconList.setBackground(Color.WHITE);
            this.iconList.setSelectionBackground(Color.RED);
            this.iconList.setSelectionForeground(Color.RED);
            this.iconList.setSelectionMode(0);
            this.iconList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        jButton.doClick();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.iconList);
            jScrollPane.setPreferredSize(new Dimension(150, 50));
            jScrollPane.setMinimumSize(new Dimension(150, 50));
            jScrollPane.setAlignmentX(0.0f);
            jScrollPane.setAlignmentY(1.0f);
            this.iconList.ensureIndexIsVisible(this.iconList.getSelectedIndex());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JLabel jLabel = new JLabel("Set " + this.objectName);
            jLabel.setLabelFor(this.iconList);
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel.add(jScrollPane);
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            this.mainPanel.add((Component)jPanel, "Center");
            this.mainPanel.add((Component)jPanel2, "South");
            this.mainDialog.setContentPane(this.mainPanel);
            this.alreadyConstructed = true;
        }
        this.mainDialog.pack();
        this.mainDialog.setLocationRelativeTo(this.parentDialog);
        this.mainDialog.setVisible(true);
    }

    public String getIconName() {
        return this.currentIconName;
    }

    public Object getIconObject() {
        return this.currentIcon;
    }

    public void setIconName(String string) {
        this.currentIconName = string;
        this.currentIcon = this.stringToIconObject.get(string);
    }

    public void setIconObject(Object object) {
        this.currentIcon = object;
        this.currentIconName = (String)this.iconObjectToString.get(object);
    }

    public JLabel getLabel() {
        return this.iconSelectionForPanel;
    }

    public JButton getButton() {
        return this.iconButton;
    }

    public class DismissIconAction
    extends AbstractAction {
        DismissIconAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IconPopupButton.this.mainDialog.dispose();
        }
    }

    public class ApplyIconAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ImageIcon imageIcon = (ImageIcon)IconPopupButton.this.iconList.getSelectedValue();
            IconPopupButton.this.setIconName(imageIcon.getDescription());
            IconPopupButton.this.iconSelectionForPanel.setIcon(imageIcon);
            IconPopupButton.this.mainDialog.dispose();
        }
    }
}

