/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ExpressionDataPopupTable
extends JDialog {
    Frame mainFrame;
    ExpressionDataPopupTable popupTable;
    private JTable table;
    ExpressionData geneExpressionInfo = null;

    public ExpressionDataPopupTable(Frame frame, String[] stringArray, String string, ExpressionData expressionData) {
        super(frame, false);
        this.mainFrame = frame;
        this.setTitle(string);
        this.geneExpressionInfo = expressionData;
        this.popupTable = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.table = new JTable(new MultipleGenesTableModel(stringArray, string));
        this.table.setDefaultRenderer(JButton.class, new ButtonCellRenderer(this.table.getDefaultRenderer(JButton.class)));
        this.table.addMouseListener(new MyMouseListener(this.table));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Dismiss");
        jButton.addActionListener(new DismissAction(this));
        jPanel2.add((Component)jButton, "Center");
        this.pack();
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
    }

    public ExpressionDataPopupTable(Frame frame, String string, String[] stringArray, ExpressionData expressionData) {
        super(frame, false);
        this.setTitle(string);
        this.geneExpressionInfo = expressionData;
        this.popupTable = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.table = new JTable(new MultipleConditionsTableModel(string, stringArray));
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 400));
        this.table.setDefaultRenderer(JButton.class, new ButtonCellRenderer(this.table.getDefaultRenderer(JButton.class)));
        this.table.addMouseListener(new MyMouseListener(this.table));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Dismiss");
        jButton.addActionListener(new DismissAction(this));
        jPanel2.add((Component)jButton, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
    }

    class MyMouseListener
    implements MouseListener {
        private JTable table;

        public MyMouseListener(JTable jTable) {
            this.table = jTable;
        }

        private void forwardEventToButton(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = mouseEvent.getY() / this.table.getRowHeight();
            if (n2 >= this.table.getRowCount() || n2 < 0 || n >= this.table.getColumnCount() || n < 0) {
                return;
            }
            Object object = this.table.getValueAt(n2, n);
            boolean bl = object instanceof JButton;
            if (!bl) {
                return;
            }
            JButton jButton = (JButton)object;
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.table, mouseEvent, jButton);
            jButton.doClick();
            this.table.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.forwardEventToButton(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;

        public ButtonCellRenderer(TableCellRenderer tableCellRenderer) {
            this.defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Component) {
                return (Component)object;
            }
            return this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class MultipleConditionsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[3];
        Object[][] data;

        public MultipleConditionsTableModel(String string, String[] stringArray) {
            this.columnNames[0] = "CONDITION";
            this.columnNames[1] = "RATIO";
            this.columnNames[2] = "LAMBDA";
            int n = stringArray.length;
            this.data = new Object[n][3];
            for (int i = 0; i < stringArray.length; ++i) {
                mRNAMeasurement mRNAMeasurement2 = ExpressionDataPopupTable.this.geneExpressionInfo.getMeasurement(string, stringArray[i]);
                String string2 = stringArray[i];
                this.data[i][0] = string2;
                if (mRNAMeasurement2 == null) {
                    this.data[i][1] = new Double(-999999.99);
                    this.data[i][2] = new Double(-999999.99);
                    continue;
                }
                this.data[i][1] = new Double(mRNAMeasurement2.getRatio());
                this.data[i][2] = new Double(mRNAMeasurement2.getSignificance());
            }
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class MultipleGenesTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[3];
        Object[][] data;

        public MultipleGenesTableModel(String[] stringArray, String string) {
            this.columnNames[0] = "GENE";
            this.columnNames[1] = "RATIO";
            this.columnNames[2] = "LAMBDA";
            int n = stringArray.length;
            this.data = new Object[n][3];
            for (int i = 0; i < stringArray.length; ++i) {
                mRNAMeasurement mRNAMeasurement2 = ExpressionDataPopupTable.this.geneExpressionInfo.getMeasurement(stringArray[i], string);
                String string2 = string;
                String string3 = stringArray[i];
                if (mRNAMeasurement2 != null) {
                    this.data[i][1] = new Double(mRNAMeasurement2.getRatio());
                    this.data[i][2] = new Double(mRNAMeasurement2.getSignificance());
                }
                JButton jButton = new JButton(stringArray[i]);
                jButton.setToolTipText("display expression values for all conditions");
                this.data[i][0] = jButton;
                ((JButton)this.data[i][0]).addActionListener(new ActionListener(this, string3){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ MultipleGenesTableModel this$1;
                    {
                        this.this$1 = multipleGenesTableModel;
                        this.val$name = string;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String[] stringArray = MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).geneExpressionInfo.getConditionNames();
                        ExpressionDataPopupTable expressionDataPopupTable = new ExpressionDataPopupTable(MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).mainFrame, this.val$name, stringArray, MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).geneExpressionInfo);
                        expressionDataPopupTable.pack();
                        expressionDataPopupTable.setLocationRelativeTo(MultipleGenesTableModel.access$000((MultipleGenesTableModel)this.this$1).mainFrame);
                        expressionDataPopupTable.setVisible(true);
                    }
                });
            }
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        static /* synthetic */ ExpressionDataPopupTable access$000(MultipleGenesTableModel multipleGenesTableModel) {
            return multipleGenesTableModel.ExpressionDataPopupTable.this;
        }
    }

    public class DismissAction
    extends AbstractAction {
        private JDialog dialog;

        DismissAction(JDialog jDialog) {
            super("");
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.dispose();
        }
    }
}

