/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.GraphObjAttributes;
import cytoscape.dialogs.GeneralColorDialogListener;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.util.MutableColor;
import cytoscape.util.MutableString;
import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.DiscreteMapper;
import cytoscape.vizmap.EdgeArrowColor;
import cytoscape.vizmap.VizMapperCategories;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EdgeTextPanel
extends JPanel {
    String[] attributeNames;
    MutableString edgeKey;
    MutableString attribKey;
    JComboBox theBox;
    JButton theButton;
    AttributeMapper aMapper;
    Frame parentFrame;
    Map theMap;
    String theMapKey;
    boolean useThisMap;
    boolean stateChanged;
    boolean useMappingGenerally;
    boolean mapSetup;

    public EdgeTextPanel(GraphObjAttributes graphObjAttributes, AttributeMapper attributeMapper, Frame frame, MutableString mutableString, Map map, String string, boolean bl) {
        this.aMapper = attributeMapper;
        this.parentFrame = frame;
        this.attributeNames = graphObjAttributes.getAttributeNames();
        this.edgeKey = mutableString;
        this.attribKey = new MutableString("");
        this.theMap = null;
        this.useThisMap = false;
        this.stateChanged = false;
        this.useMappingGenerally = bl;
        this.setLayout(new GridLayout(1, 3, 10, 10));
        JCheckBox jCheckBox = new JCheckBox("Use Mapping?", this.useMappingGenerally);
        jCheckBox.addItemListener(new UseMappingListener());
        this.add(jCheckBox);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            defaultComboBoxModel.addElement(new String(this.attributeNames[i]));
        }
        this.theBox = new JComboBox(defaultComboBoxModel);
        this.mapSetup = this.prepTheBox(defaultComboBoxModel, map, string);
        this.add(this.theBox);
        this.theButton = new JButton("Define Mapping");
        this.theButton.addActionListener(new ColorToDiscreteListener());
        this.add(this.theButton);
        this.whetherMenuIsEnabled();
    }

    private boolean prepTheBox(DefaultComboBoxModel defaultComboBoxModel, Map map, String string) {
        boolean bl = false;
        this.theBox.addActionListener(new BoxAction(this.edgeKey));
        if (defaultComboBoxModel.getSize() == 1) {
            this.theBox.setSelectedIndex(0);
            this.edgeKey.setString((String)defaultComboBoxModel.getElementAt(0));
            bl = this.setupTheMap(map, string);
        } else if (this.edgeKey.getString() != null) {
            this.theBox.setSelectedItem(this.edgeKey.getString());
            bl = this.setupTheMap(map, string);
        } else if (defaultComboBoxModel.getSize() >= 1) {
            this.theBox.setSelectedIndex(0);
            this.edgeKey.setString((String)defaultComboBoxModel.getElementAt(0));
            bl = this.setupTheMap(map, string);
        }
        return bl;
    }

    public Map getMap() {
        return this.theMap;
    }

    public boolean didStateChange() {
        return this.stateChanged;
    }

    public boolean useMappingGenerally() {
        return this.useMappingGenerally;
    }

    public void updateMapperScalableArrows() {
        Color color;
        String string;
        TreeMap<String, Color> treeMap = new TreeMap<String, Color>();
        Set set = this.theMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            color = (Color)this.theMap.get(string);
            treeMap.put(string, color);
        }
        set = treeMap.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            color = (Color)this.theMap.get(string);
            EdgeArrowColor.removeThenAddEdgeColor(this.aMapper, string, color);
        }
    }

    public boolean getWhetherToUseTheMap() {
        return this.useThisMap;
    }

    public void setWhetherToUseTheMap(boolean bl) {
        this.useThisMap = bl;
    }

    public void whetherMenuIsEnabled() {
        this.theBox.setEnabled(this.useMappingGenerally);
        this.theButton.setEnabled(this.useMappingGenerally);
    }

    private boolean setupTheMap(Map map, String string) {
        boolean bl = false;
        String string2 = this.aMapper.getControllingDomainAttributeName(VizMapperCategories.EDGE_COLOR);
        if (string2 == null) {
            this.theMap = map;
            this.theMapKey = string;
            bl = true;
        } else if (string2.equals(this.edgeKey.getString())) {
            bl = true;
            DiscreteMapper discreteMapper = (DiscreteMapper)this.aMapper.getValueMapper(VizMapperCategories.EDGE_COLOR);
            if (this.theMap == null || !this.theMapKey.equals(string2)) {
                System.out.println("In setupTheMap, creating");
                this.theMap = new HashMap(discreteMapper.getValueMap());
                this.theMapKey = string2;
            }
        }
        return bl;
    }

    public class ColorToDiscreteDialog
    extends JDialog {
        JPanel extScrollPanel;
        JPanel intScrollPanel;

        public ColorToDiscreteDialog() {
            super(EdgeTextPanel.this.parentFrame, true);
            this.setTitle("Colors for " + EdgeTextPanel.this.edgeKey.getString() + " types");
            GridBagGroup gridBagGroup = new GridBagGroup();
            this.intScrollPanel = gridBagGroup.panel;
            if (EdgeTextPanel.this.mapSetup) {
                Set set = EdgeTextPanel.this.theMap.keySet();
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    String string = (String)k;
                    JButton jButton = new JButton(string);
                    JLabel jLabel = new JLabel("       ");
                    jLabel.setOpaque(true);
                    jLabel.setBackground((Color)EdgeTextPanel.this.theMap.get(string));
                    String string2 = EdgeTextPanel.this.edgeKey.getString() + " / " + string;
                    jButton.addActionListener(new MapStringListener(this, EdgeTextPanel.this.theMap, string, jLabel, string2));
                    MiscGB.insert(gridBagGroup, jButton, 0, n, 1, 1, 1);
                    MiscGB.insert(gridBagGroup, jLabel, 1, n, 1, 1, 3);
                    ++n;
                }
            } else {
                return;
            }
            this.arrangeInterface(this.intScrollPanel, this.extScrollPanel);
            this.setLocationRelativeTo(EdgeTextPanel.this);
            this.setVisible(true);
        }

        private void arrangeInterface(JPanel jPanel, JPanel jPanel2) {
            GridBagGroup gridBagGroup = new GridBagGroup();
            JScrollPane jScrollPane = new JScrollPane(jPanel, 22, 30);
            jPanel2 = new JPanel(new GridLayout(1, 1));
            jPanel2.add(jScrollPane);
            MiscGB.insert(gridBagGroup, jPanel2, 0, 0, 2, 1);
            JButton jButton = new JButton("Cancel");
            jButton.addActionListener(new CancelAction());
            MiscGB.insert(gridBagGroup, (Component)jButton, 0, 3);
            JButton jButton2 = new JButton("Apply");
            jButton2.addActionListener(new ApplyAction());
            MiscGB.insert(gridBagGroup, (Component)jButton2, 1, 3);
            this.setContentPane(gridBagGroup.panel);
            Dimension dimension = jScrollPane.getPreferredSize();
            int n = (int)dimension.getHeight();
            if (n > 150) {
                n = 150;
            }
            jScrollPane.setPreferredSize(new Dimension((int)dimension.getWidth(), n));
            this.pack();
        }

        public class ApplyAction
        extends AbstractAction {
            ApplyAction() {
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.useThisMap = true;
                ((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.stateChanged = true;
                ColorToDiscreteDialog.this.dispose();
            }
        }

        public class CancelAction
        extends AbstractAction {
            CancelAction() {
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColorToDiscreteDialog.this.dispose();
            }
        }

        public class EditAction
        extends AbstractAction {
            EditAction() {
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MutableColor mutableColor = new MutableColor((Color)((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.theMap.get(((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.attribKey.getString()));
                GeneralColorDialogListener generalColorDialogListener = new GeneralColorDialogListener(ColorToDiscreteDialog.this, mutableColor, ((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.edgeKey.getString() + "/" + ((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.attribKey.getString());
                generalColorDialogListener.popup();
                ((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.theMap.remove(((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.attribKey.getString());
                ((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.theMap.put(((ColorToDiscreteDialog)ColorToDiscreteDialog.this).EdgeTextPanel.this.attribKey.getString(), mutableColor.getColor());
            }
        }
    }

    public class MapStringListener
    extends AbstractAction {
        JLabel label;
        Map theMap;
        Component component;
        String key;
        String title;

        public MapStringListener(Component component, Map map, String string, JLabel jLabel, String string2) {
            this.label = jLabel;
            this.theMap = map;
            this.key = string;
            this.component = component;
            this.title = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MutableColor mutableColor = new MutableColor((Color)this.theMap.get(this.key));
            GeneralColorDialogListener generalColorDialogListener = new GeneralColorDialogListener(this.component, mutableColor, this.label, this.title);
            generalColorDialogListener.popup();
            this.theMap.put(this.key, mutableColor.getColor());
        }
    }

    public class UseMappingListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getItem();
            EdgeTextPanel.this.useMappingGenerally = jCheckBox.isSelected();
            EdgeTextPanel.this.whetherMenuIsEnabled();
            EdgeTextPanel.this.stateChanged = true;
        }
    }

    public class ColorToDiscreteListener
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ColorToDiscreteDialog colorToDiscreteDialog = new ColorToDiscreteDialog();
        }
    }

    public class BoxAction
    extends AbstractAction {
        MutableString ms;

        public BoxAction(MutableString mutableString) {
            this.ms = mutableString;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.ms.setString((String)jComboBox.getSelectedItem());
        }
    }
}

