/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.undo.UndoableGraphHider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import y.base.Edge;
import y.base.EdgeCursor;
import y.view.EdgeRealizer;
import y.view.Graph2D;

public class EdgeControlDialog
extends JDialog {
    CytoscapeWindow cytoscapeWindow;
    Graph2D graph;
    String[] edgeNames;
    HashMap edgeNamesHash;
    TreePath[] selectedTreePaths;
    GraphObjAttributes edgeAttributes;
    UndoableGraphHider graphHider;
    JTree tree;

    public EdgeControlDialog(CytoscapeWindow cytoscapeWindow, HashMap hashMap, String string) {
        super((Frame)cytoscapeWindow.getMainFrame(), false);
        this.cytoscapeWindow = cytoscapeWindow;
        this.edgeNamesHash = hashMap;
        this.graph = cytoscapeWindow.getGraph();
        this.graphHider = cytoscapeWindow.getGraphHider();
        this.edgeAttributes = cytoscapeWindow.getEdgeAttributes();
        this.setTitle(string);
        this.setContentPane(this.createTreeViewGui());
    }

    JPanel createTreeViewGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.createTreeView(this.edgeNamesHash));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2));
        JButton jButton = new JButton("Hide");
        JButton jButton2 = new JButton("Hide Others");
        JButton jButton3 = new JButton("Hide All");
        JButton jButton4 = new JButton("Show All");
        JButton jButton5 = new JButton("Select");
        JButton jButton6 = new JButton("Select Others");
        JButton jButton7 = new JButton("Select All");
        JButton jButton8 = new JButton("Deselect All");
        JButton jButton9 = new JButton("Dismiss");
        jPanel2.add(jButton5);
        jPanel2.add(jButton);
        jPanel2.add(jButton6);
        jPanel2.add(jButton2);
        jPanel2.add(jButton7);
        jPanel2.add(jButton3);
        jPanel2.add(jButton8);
        jPanel2.add(jButton4);
        jButton.addActionListener(new HideAction());
        jButton2.addActionListener(new HideOthersAction());
        jButton3.addActionListener(new HideAllAction());
        jButton4.addActionListener(new ShowAllAction());
        jButton5.addActionListener(new SelectAction());
        jButton7.addActionListener(new SelectAllAction());
        jButton8.addActionListener(new DeselectAllAction());
        jButton6.addActionListener(new SelectOthersAction());
        jButton9.addActionListener(new DismissAction());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jButton9, "South");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    protected JTree createTreeView(HashMap hashMap) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Edge Attributes");
        this.createTreeNodes(defaultMutableTreeNode, hashMap);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        return this.tree;
    }

    protected void createTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, HashMap hashMap) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Object var4_4 = null;
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < stringArray.length; ++i) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[i]);
            String[] stringArray2 = (String[])hashMap.get(stringArray[i]);
            Arrays.sort(stringArray2, String.CASE_INSENSITIVE_ORDER);
            for (int j = 0; j < stringArray2.length; ++j) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(stringArray2[j]));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    boolean pathMatchesEdge(String string, TreePath treePath, GraphObjAttributes graphObjAttributes) {
        int n;
        Object[] objectArray = treePath.getPath();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = objectArray[n].toString();
        }
        n = stringArray.length;
        if (n < 2) {
            return false;
        }
        if (!graphObjAttributes.hasAttribute(stringArray[1], string)) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        if (n == 3) {
            String[] stringArray2 = graphObjAttributes.getStringArrayValues(stringArray[1], string);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equalsIgnoreCase(stringArray[2])) continue;
                return true;
            }
        }
        return false;
    }

    protected void hideEdgesByName(TreePath treePath) {
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            String string = this.edgeAttributes.getCanonicalName(edge);
            if (this.pathMatchesEdge(string, treePath, this.edgeAttributes)) {
                this.graphHider.hide(edge);
            }
            edgeCursor.next();
        }
    }

    protected void hideOtherEdges() {
        Edge edge;
        Vector<Edge> vector = new Vector<Edge>();
        if (this.selectedTreePaths == null) {
            return;
        }
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            edge = edgeCursor.edge();
            String string = this.edgeAttributes.getCanonicalName(edge);
            for (int i = 0; i < this.selectedTreePaths.length; ++i) {
                TreePath treePath = this.selectedTreePaths[i];
                if (!this.pathMatchesEdge(string, treePath, this.edgeAttributes)) continue;
                vector.add(edge);
            }
            edgeCursor.next();
        }
        edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            edge = edgeCursor.edge();
            if (!vector.contains(edge)) {
                this.graphHider.hide(edge);
            }
            edgeCursor.next();
        }
    }

    protected void inverseHideEdgesByName(TreePath treePath) {
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            String string = this.edgeAttributes.getCanonicalName(edge);
            if (!this.pathMatchesEdge(string, treePath, this.edgeAttributes)) {
                this.graphHider.hide(edge);
            }
            edgeCursor.next();
        }
    }

    protected void selectEdgesByName(TreePath treePath) {
        Vector<Edge> vector = new Vector<Edge>();
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            String string = this.edgeAttributes.getCanonicalName(edge);
            if (this.pathMatchesEdge(string, treePath, this.edgeAttributes)) {
                vector.add(edge);
            }
            edgeCursor.next();
        }
        this.cytoscapeWindow.selectEdges(vector.toArray(new Edge[0]), false);
    }

    protected void selectAllEdges() {
        Vector<Edge> vector = new Vector<Edge>();
        EdgeCursor edgeCursor = this.graph.edges();
        while (edgeCursor.ok()) {
            vector.add(edgeCursor.edge());
            edgeCursor.next();
        }
        this.cytoscapeWindow.selectEdges(vector.toArray(new Edge[0]), false);
    }

    protected void invertEdgeSelection() {
        Edge[] edgeArray = this.graph.getEdgeArray();
        for (int i = 0; i < edgeArray.length; ++i) {
            EdgeRealizer edgeRealizer;
            edgeRealizer.setSelected(!(edgeRealizer = this.graph.getRealizer(edgeArray[i])).isSelected());
        }
    }

    protected void selectOtherEdges() {
        String string;
        Edge edge;
        Vector<Edge> vector = new Vector<Edge>();
        Object object = this.graph.edges();
        while (object.ok()) {
            edge = object.edge();
            string = this.edgeAttributes.getCanonicalName(edge);
            for (int i = 0; i < this.selectedTreePaths.length; ++i) {
                TreePath treePath = this.selectedTreePaths[i];
                if (!this.pathMatchesEdge(string, treePath, this.edgeAttributes)) continue;
                vector.add(edge);
            }
            object.next();
        }
        object = new Vector();
        edge = this.graph.edges();
        while (edge.ok()) {
            string = edge.edge();
            EdgeRealizer edgeRealizer = this.graph.getRealizer((Edge)string);
            edgeRealizer.setSelected(!vector.contains(string));
            edge.next();
        }
    }

    protected void deselectAllEdges() {
        this.graph.unselectEdges();
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.dispose();
        }
    }

    class ShowAllAction
    extends AbstractAction {
        ShowAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.graphHider.unhideEdges();
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.selectAllEdges();
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class HideAllAction
    extends AbstractAction {
        HideAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.graphHider.hideEdges();
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class HideOthersAction
    extends AbstractAction {
        HideOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.graphHider.unhideEdges();
            EdgeControlDialog.this.hideOtherEdges();
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class DeselectAllAction
    extends AbstractAction {
        DeselectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.deselectAllEdges();
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class SelectOthersAction
    extends AbstractAction {
        SelectOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EdgeControlDialog.this.selectOtherEdges();
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class HideAction
    extends AbstractAction {
        HideAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EdgeControlDialog.this.selectedTreePaths == null || EdgeControlDialog.this.selectedTreePaths.length == 0) {
                EdgeControlDialog.this.getToolkit().beep();
                return;
            }
            EdgeControlDialog.this.graphHider.unhideEdges();
            String string = actionEvent.getActionCommand();
            for (int i = 0; i < EdgeControlDialog.this.selectedTreePaths.length; ++i) {
                EdgeControlDialog.this.hideEdgesByName(EdgeControlDialog.this.selectedTreePaths[i]);
            }
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class SelectAction
    extends AbstractAction {
        SelectAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EdgeControlDialog.this.selectedTreePaths == null || EdgeControlDialog.this.selectedTreePaths.length == 0) {
                EdgeControlDialog.this.getToolkit().beep();
                return;
            }
            EdgeControlDialog.this.cytoscapeWindow.getGraph().unselectEdges();
            for (int i = 0; i < EdgeControlDialog.this.selectedTreePaths.length; ++i) {
                EdgeControlDialog.this.selectEdgesByName(EdgeControlDialog.this.selectedTreePaths[i]);
            }
            EdgeControlDialog.this.cytoscapeWindow.redrawGraph();
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)EdgeControlDialog.this.tree.getLastSelectedPathComponent();
            EdgeControlDialog.this.selectedTreePaths = EdgeControlDialog.this.tree.getSelectionPaths();
        }
    }
}

