/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ColorScaleTable
extends JPanel {
    public ColorScaleTable(int n, int n2, double[][] dArray) {
        MyTableModel myTableModel = new MyTableModel(dArray);
        JTable jTable = new JTable(myTableModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(n, n2));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.setUpColorRenderer(jTable);
        this.add(jScrollPane);
    }

    private void setUpColorRenderer(JTable jTable) {
        jTable.setDefaultRenderer(Color.class, new ColorRenderer(false));
    }

    class MyTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Value", "Color"};
        final Object[][] data;

        MyTableModel(double[][] dArray) {
            int n = dArray.length;
            this.data = new Object[n][2];
            for (int i = 0; i < n; ++i) {
                this.data[i][0] = new Double(dArray[i][0]);
                Color color = new Color((int)dArray[i][1], (int)dArray[i][2], (int)dArray[i][3]);
                this.data[i][1] = color;
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((Color)object);
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

