/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorPopupButton
extends JPanel
implements ActionListener {
    Color currentColor;
    JColorChooser colorChoice;
    final JLabel color = new JLabel(" ");
    final JLabel identifier = new JLabel("   Current Color:   ");
    JFrame mainFrame;
    JPanel mainPanel;
    JLabel colorSelectionForPanel;
    JButton colorButton;
    String name;
    String title;

    public ColorPopupButton(String string, Color color) {
        this.title = string;
        this.currentColor = color;
        this.setup();
    }

    public ColorPopupButton(String string, String string2, Color color) {
        this.title = string2;
        this.currentColor = color;
        this.name = string;
        this.setup();
    }

    private void setup() {
        this.colorButton = new JButton(this.title);
        this.colorButton.addActionListener(this);
        this.mainPanel = new JPanel();
        this.colorSelectionForPanel = new JLabel("     ");
        this.colorSelectionForPanel.setOpaque(true);
        this.colorSelectionForPanel.setBackground(this.currentColor);
        this.add(this.colorButton);
        this.add(this.colorSelectionForPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.mainFrame = new JFrame("Color Chooser");
        this.mainFrame.setLocation(this.colorButton.getLocationOnScreen());
        this.color.setBackground(this.currentColor);
        this.color.setOpaque(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.identifier, "West");
        jPanel.add((Component)this.color, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.colorChoice = new JColorChooser(this.currentColor);
        this.colorChoice.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Color color = ColorPopupButton.this.colorChoice.getColor();
                ColorPopupButton.this.color.setBackground(color);
            }
        });
        this.colorChoice.setPreviewPanel(new JPanel());
        JScrollPane jScrollPane = new JScrollPane(this.colorChoice);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Set Color");
        JButton jButton2 = new JButton("Dismiss");
        jPanel3.setLayout(new GridLayout(0, 2));
        jButton.addActionListener(new ApplyColorAction());
        jButton2.addActionListener(new DismissColorAction());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "South");
        this.mainFrame.getContentPane().add(jPanel2);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    public void setColor(Color color) {
        this.colorSelectionForPanel.setBackground(color);
    }

    public Color getColor() {
        return this.currentColor;
    }

    public class DismissColorAction
    extends AbstractAction {
        DismissColorAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColorPopupButton.this.mainFrame.dispose();
        }
    }

    public class ApplyColorAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPopupButton.this.currentColor = ColorPopupButton.this.colorChoice.getColor();
            String string = ColorPopupButton.this.title;
            ColorPopupButton.this.setColor(ColorPopupButton.this.currentColor);
            ColorPopupButton.this.mainFrame.dispose();
        }
    }
}

