/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.dialogs.MiscGB;
import cytoscape.util.MutableColor;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import y.base.Node;

public class ColorNodesFromFileDialog
extends JDialog {
    protected CytoscapeWindow cytoscapeWindow;
    static final int FIELD_WIDTH = 30;
    JPanel mainPanel;
    JPanel filePanel;
    JLabel fileNameLabel;
    JTextField fileNameField;
    JButton browseButton;
    JPanel colorPanel;
    JButton fColorButton;
    JLabel fColorLabel;
    MutableColor fColor;
    JPanel buttonPanel;
    JButton dismissButton;
    JButton applyButton;
    Border paneEdge;
    File currentDirectory;

    public ColorNodesFromFileDialog(CytoscapeWindow cytoscapeWindow) {
        super((Frame)cytoscapeWindow.getMainFrame(), false);
        this.cytoscapeWindow = cytoscapeWindow;
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.setTitle("Color Nodes From File");
        this.createUI();
    }

    protected void setColorCalculator() {
        VisualMappingManager visualMappingManager = this.cytoscapeWindow.getVizMapManager();
        NodeAppearanceCalculator nodeAppearanceCalculator = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
        NodeColorCalculator nodeColorCalculator = nodeAppearanceCalculator.getNodeFillColorCalculator();
        GenericNodeColorCalculator genericNodeColorCalculator = (GenericNodeColorCalculator)nodeColorCalculator;
        ObjectMapping objectMapping = genericNodeColorCalculator.getMapping();
        DiscreteMapping discreteMapping = !(objectMapping instanceof DiscreteMapping) ? new DiscreteMapping(Color.WHITE, 1) : (DiscreteMapping)objectMapping;
        discreteMapping.setControllingAttributeName("nodeInFile", visualMappingManager.getNetwork(), true);
        discreteMapping.put(this.fColor.getColor().toString(), this.fColor.getColor());
        GenericNodeColorCalculator genericNodeColorCalculator2 = new GenericNodeColorCalculator("Color Nodes From File", discreteMapping);
        nodeAppearanceCalculator.setNodeFillColorCalculator(genericNodeColorCalculator2);
        visualMappingManager.applyAppearances();
    }

    protected void createUI() {
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.paneEdge = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.mainPanel.setBorder(this.paneEdge);
        this.paneEdge = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.filePanel = new JPanel();
        this.filePanel.setBorder(this.paneEdge);
        this.filePanel.setLayout(new BoxLayout(this.filePanel, 0));
        this.fileNameLabel = new JLabel("File:");
        this.filePanel.add(this.fileNameLabel);
        this.fileNameField = new JTextField(30);
        this.filePanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.filePanel.add(this.fileNameField);
        this.browseButton = new JButton("Browse");
        this.browseButton.addActionListener(new BrowseButtonAction(this.fileNameField));
        this.filePanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.filePanel.add(this.browseButton);
        this.mainPanel.add(this.filePanel);
        this.colorPanel = new JPanel();
        this.colorPanel.setBorder(this.paneEdge);
        this.colorPanel.setLayout(new BoxLayout(this.colorPanel, 0));
        this.fColor = new MutableColor(Color.CYAN);
        this.fColorLabel = MiscGB.createColorLabel(Color.CYAN);
        this.fColorLabel.addPropertyChangeListener("background", new UpdateFillColorListener());
        this.fColorButton = MiscGB.buttonAndColor(this, this.fColor, this.fColorLabel, "Choose Fill Color");
        this.colorPanel.add(Box.createRigidArea(new Dimension(32, 15)));
        this.colorPanel.add(this.fColorButton);
        this.colorPanel.add(Box.createRigidArea(new Dimension(15, 15)));
        this.colorPanel.add(this.fColorLabel);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ApplyAction());
        this.colorPanel.add(Box.createRigidArea(new Dimension(75, 15)));
        this.colorPanel.add(this.applyButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(new DismissAction());
        this.colorPanel.add(Box.createRigidArea(new Dimension(15, 15)));
        this.colorPanel.add(this.dismissButton);
        this.mainPanel.add(this.colorPanel);
        this.setContentPane(this.mainPanel);
    }

    public class UpdateFillColorListener
    implements PropertyChangeListener {
        UpdateFillColorListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("background")) {
                Color color = ColorNodesFromFileDialog.this.fColor.getColor();
            }
        }
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColorNodesFromFileDialog.this.dispose();
        }
    }

    public class BrowseButtonAction
    extends AbstractAction {
        JTextField field;

        BrowseButtonAction(JTextField jTextField) {
            super("");
            this.field = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(ColorNodesFromFileDialog.this.currentDirectory);
            if (jFileChooser.showOpenDialog(ColorNodesFromFileDialog.this) == 0) {
                ColorNodesFromFileDialog.this.currentDirectory = jFileChooser.getCurrentDirectory();
                String string = jFileChooser.getSelectedFile().toString();
                this.field.setText(string);
            }
        }
    }

    public class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ColorNodesFromFileDialog.this.fileNameField.getText();
            if (string.length() == 0) {
                return;
            }
            try {
                FileReader fileReader = new FileReader(string);
                LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                GraphObjAttributes graphObjAttributes = ColorNodesFromFileDialog.this.cytoscapeWindow.getNodeAttributes();
                Color color = ColorNodesFromFileDialog.this.fColor.getColor();
                String string2 = lineNumberReader.readLine();
                int n = 0;
                while (string2 != null) {
                    Node node = (Node)graphObjAttributes.getGraphObject(string2);
                    if (node != null) {
                        graphObjAttributes.set("node.fillColor", string2, color);
                        ++n;
                    }
                    string2 = lineNumberReader.readLine();
                }
                if (n > 0) {
                    ColorNodesFromFileDialog.this.cytoscapeWindow.redrawGraph(false, true);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, "Could not open or read file.\nCheck format and name.", "Error", 0);
            }
        }
    }
}

